// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookFunctionsTimevalueRequest;
import com.microsoft.graph.requests.extensions.WorkbookFunctionsTimevalueRequest;
import com.microsoft.graph.models.extensions.WorkbookFunctionResult;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Timevalue Request Builder.
 */
public class WorkbookFunctionsTimevalueRequestBuilder extends BaseActionRequestBuilder implements IWorkbookFunctionsTimevalueRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsTimevalue
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param timeText the timeText
     */
    public WorkbookFunctionsTimevalueRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final com.google.gson.JsonElement timeText) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("timeText", timeText);
    }

    /**
     * Creates the IWorkbookFunctionsTimevalueRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsTimevalueRequest instance
     */
    public IWorkbookFunctionsTimevalueRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookFunctionsTimevalueRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookFunctionsTimevalueRequest instance
     */
    public IWorkbookFunctionsTimevalueRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookFunctionsTimevalueRequest request = new WorkbookFunctionsTimevalueRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("timeText")) {
            request.body.timeText = getParameter("timeText");
        }

        return request;
    }
}
