/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ClaimsMappingPolicyCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IClaimsMappingPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IClaimsMappingPolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IClaimsMappingPolicyCollectionWithReferencesRequest;
import java.util.List;

public class ClaimsMappingPolicyCollectionWithReferencesRequest
extends BaseCollectionRequest<ClaimsMappingPolicyCollectionResponse, IClaimsMappingPolicyCollectionPage>
implements IClaimsMappingPolicyCollectionWithReferencesRequest {
    public ClaimsMappingPolicyCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ClaimsMappingPolicyCollectionResponse.class, IClaimsMappingPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IClaimsMappingPolicyCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ClaimsMappingPolicyCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IClaimsMappingPolicyCollectionWithReferencesPage get() throws ClientException {
        ClaimsMappingPolicyCollectionResponse response = (ClaimsMappingPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IClaimsMappingPolicyCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IClaimsMappingPolicyCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IClaimsMappingPolicyCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IClaimsMappingPolicyCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IClaimsMappingPolicyCollectionWithReferencesPage buildFromResponse(ClaimsMappingPolicyCollectionResponse response) {
        ClaimsMappingPolicyCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new ClaimsMappingPolicyCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ClaimsMappingPolicyCollectionWithReferencesPage page = new ClaimsMappingPolicyCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

