/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileLobApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileLobAppCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileLobAppCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileLobAppCollectionPage;
import com.microsoft.graph.requests.extensions.MobileLobAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileLobAppCollectionResponse;
import com.microsoft.graph.requests.extensions.MobileLobAppRequestBuilder;
import java.util.List;

public class MobileLobAppCollectionRequest
extends BaseCollectionRequest<MobileLobAppCollectionResponse, IMobileLobAppCollectionPage>
implements IMobileLobAppCollectionRequest {
    public MobileLobAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileLobAppCollectionResponse.class, IMobileLobAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IMobileLobAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileLobAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileLobAppCollectionPage get() throws ClientException {
        MobileLobAppCollectionResponse response = (MobileLobAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileLobApp newMobileLobApp, ICallback<? super MobileLobApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileLobAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileLobApp, callback);
    }

    @Override
    public MobileLobApp post(MobileLobApp newMobileLobApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileLobAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileLobApp);
    }

    @Override
    public IMobileLobAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMobileLobAppCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IMobileLobAppCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IMobileLobAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileLobAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMobileLobAppCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMobileLobAppCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMobileLobAppCollectionPage buildFromResponse(MobileLobAppCollectionResponse response) {
        MobileLobAppCollectionRequestBuilder builder = response.nextLink != null ? new MobileLobAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileLobAppCollectionPage page = new MobileLobAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

