/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintTaskTrigger;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintTaskTriggerCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerCollectionPage;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintTaskTriggerRequestBuilder;
import java.util.List;

public class PrintTaskTriggerCollectionRequest
extends BaseCollectionRequest<PrintTaskTriggerCollectionResponse, IPrintTaskTriggerCollectionPage>
implements IPrintTaskTriggerCollectionRequest {
    public PrintTaskTriggerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTaskTriggerCollectionResponse.class, IPrintTaskTriggerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintTaskTriggerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintTaskTriggerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintTaskTriggerCollectionPage get() throws ClientException {
        PrintTaskTriggerCollectionResponse response = (PrintTaskTriggerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintTaskTrigger newPrintTaskTrigger, ICallback<? super PrintTaskTrigger> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintTaskTriggerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintTaskTrigger, callback);
    }

    @Override
    public PrintTaskTrigger post(PrintTaskTrigger newPrintTaskTrigger) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintTaskTriggerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintTaskTrigger);
    }

    @Override
    public IPrintTaskTriggerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintTaskTriggerCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintTaskTriggerCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintTaskTriggerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintTaskTriggerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintTaskTriggerCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintTaskTriggerCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintTaskTriggerCollectionPage buildFromResponse(PrintTaskTriggerCollectionResponse response) {
        PrintTaskTriggerCollectionRequestBuilder builder = response.nextLink != null ? new PrintTaskTriggerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintTaskTriggerCollectionPage page = new PrintTaskTriggerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

