// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.DocumentSetVersionItem;
import com.microsoft.graph.models.ListItemVersion;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Document Set Version.
 */
public class DocumentSetVersion extends ListItemVersion implements IJsonBackedObject {


    /**
     * The Comment.
     * Comment about the captured version.
     */
    @SerializedName(value = "comment", alternate = {"Comment"})
    @Expose
	@Nullable
    public String comment;

    /**
     * The Created By.
     * User who captured the version.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public IdentitySet createdBy;

    /**
     * The Created Date Time.
     * Date and time when this version was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Items.
     * Items within the document set that are captured as part of this version.
     */
    @SerializedName(value = "items", alternate = {"Items"})
    @Expose
	@Nullable
    public java.util.List<DocumentSetVersionItem> items;

    /**
     * The Should Capture Minor Version.
     * If true, minor versions of items are also captured; otherwise, only major versions will be captured. Default value is false.
     */
    @SerializedName(value = "shouldCaptureMinorVersion", alternate = {"ShouldCaptureMinorVersion"})
    @Expose
	@Nullable
    public Boolean shouldCaptureMinorVersion;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
