// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ComplianceState;
import com.microsoft.graph.models.ConfigurationManagerClientEnabledFeatures;
import com.microsoft.graph.models.DeviceActionResult;
import com.microsoft.graph.models.DeviceEnrollmentType;
import com.microsoft.graph.models.DeviceHealthAttestationState;
import com.microsoft.graph.models.DeviceRegistrationState;
import com.microsoft.graph.models.DeviceManagementExchangeAccessState;
import com.microsoft.graph.models.DeviceManagementExchangeAccessStateReason;
import com.microsoft.graph.models.ManagedDeviceOwnerType;
import com.microsoft.graph.models.ManagementAgentType;
import com.microsoft.graph.models.ManagedDevicePartnerReportedHealthState;
import com.microsoft.graph.models.DeviceCategory;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.DeviceCompliancePolicyStateCollectionPage;
import com.microsoft.graph.requests.DeviceConfigurationStateCollectionPage;
import com.microsoft.graph.requests.UserCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device.
 */
public class ManagedDevice extends Entity implements IJsonBackedObject {


    /**
     * The Activation Lock Bypass Code.
     * The code that allows the Activation Lock on managed device to be bypassed. Default, is Null (Non-Default property) for this property when returned as part of managedDevice entity in LIST call. Individual GET call with select query options is needed to retrieve actual values. Supports: $select. $Search is not supported. Read-only. This property is read-only.
     */
    @SerializedName(value = "activationLockBypassCode", alternate = {"ActivationLockBypassCode"})
    @Expose
	@Nullable
    public String activationLockBypassCode;

    /**
     * The Android Security Patch Level.
     * Android security patch level. This property is read-only.
     */
    @SerializedName(value = "androidSecurityPatchLevel", alternate = {"AndroidSecurityPatchLevel"})
    @Expose
	@Nullable
    public String androidSecurityPatchLevel;

    /**
     * The Azure ADDevice Id.
     * The unique identifier for the Azure Active Directory device. Read only. This property is read-only.
     */
    @SerializedName(value = "azureADDeviceId", alternate = {"AzureADDeviceId"})
    @Expose
	@Nullable
    public String azureADDeviceId;

    /**
     * The Azure ADRegistered.
     * Whether the device is Azure Active Directory registered. This property is read-only.
     */
    @SerializedName(value = "azureADRegistered", alternate = {"AzureADRegistered"})
    @Expose
	@Nullable
    public Boolean azureADRegistered;

    /**
     * The Compliance Grace Period Expiration Date Time.
     * The DateTime when device compliance grace period expires. This property is read-only.
     */
    @SerializedName(value = "complianceGracePeriodExpirationDateTime", alternate = {"ComplianceGracePeriodExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime complianceGracePeriodExpirationDateTime;

    /**
     * The Compliance State.
     * Compliance state of the device. This property is read-only. Possible values are: unknown, compliant, noncompliant, conflict, error, inGracePeriod, configManager.
     */
    @SerializedName(value = "complianceState", alternate = {"ComplianceState"})
    @Expose
	@Nullable
    public ComplianceState complianceState;

    /**
     * The Configuration Manager Client Enabled Features.
     * ConfigrMgr client enabled features. This property is read-only.
     */
    @SerializedName(value = "configurationManagerClientEnabledFeatures", alternate = {"ConfigurationManagerClientEnabledFeatures"})
    @Expose
	@Nullable
    public ConfigurationManagerClientEnabledFeatures configurationManagerClientEnabledFeatures;

    /**
     * The Device Action Results.
     * List of ComplexType deviceActionResult objects. This property is read-only.
     */
    @SerializedName(value = "deviceActionResults", alternate = {"DeviceActionResults"})
    @Expose
	@Nullable
    public java.util.List<DeviceActionResult> deviceActionResults;

    /**
     * The Device Category Display Name.
     * Device category display name. This property is read-only.
     */
    @SerializedName(value = "deviceCategoryDisplayName", alternate = {"DeviceCategoryDisplayName"})
    @Expose
	@Nullable
    public String deviceCategoryDisplayName;

    /**
     * The Device Enrollment Type.
     * Enrollment type of the device. This property is read-only. Possible values are: unknown, userEnrollment, deviceEnrollmentManager, appleBulkWithUser, appleBulkWithoutUser, windowsAzureADJoin, windowsBulkUserless, windowsAutoEnrollment, windowsBulkAzureDomainJoin, windowsCoManagement, windowsAzureADJoinUsingDeviceAuth, appleUserEnrollment, appleUserEnrollmentWithServiceAccount.
     */
    @SerializedName(value = "deviceEnrollmentType", alternate = {"DeviceEnrollmentType"})
    @Expose
	@Nullable
    public DeviceEnrollmentType deviceEnrollmentType;

    /**
     * The Device Health Attestation State.
     * The device health attestation state. This property is read-only.
     */
    @SerializedName(value = "deviceHealthAttestationState", alternate = {"DeviceHealthAttestationState"})
    @Expose
	@Nullable
    public DeviceHealthAttestationState deviceHealthAttestationState;

    /**
     * The Device Name.
     * Name of the device. This property is read-only.
     */
    @SerializedName(value = "deviceName", alternate = {"DeviceName"})
    @Expose
	@Nullable
    public String deviceName;

    /**
     * The Device Registration State.
     * Device registration state. This property is read-only. Possible values are: notRegistered, registered, revoked, keyConflict, approvalPending, certificateReset, notRegisteredPendingEnrollment, unknown.
     */
    @SerializedName(value = "deviceRegistrationState", alternate = {"DeviceRegistrationState"})
    @Expose
	@Nullable
    public DeviceRegistrationState deviceRegistrationState;

    /**
     * The Eas Activated.
     * Whether the device is Exchange ActiveSync activated. This property is read-only.
     */
    @SerializedName(value = "easActivated", alternate = {"EasActivated"})
    @Expose
	@Nullable
    public Boolean easActivated;

    /**
     * The Eas Activation Date Time.
     * Exchange ActivationSync activation time of the device. This property is read-only.
     */
    @SerializedName(value = "easActivationDateTime", alternate = {"EasActivationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime easActivationDateTime;

    /**
     * The Eas Device Id.
     * Exchange ActiveSync Id of the device. This property is read-only.
     */
    @SerializedName(value = "easDeviceId", alternate = {"EasDeviceId"})
    @Expose
	@Nullable
    public String easDeviceId;

    /**
     * The Email Address.
     * Email(s) for the user associated with the device. This property is read-only.
     */
    @SerializedName(value = "emailAddress", alternate = {"EmailAddress"})
    @Expose
	@Nullable
    public String emailAddress;

    /**
     * The Enrolled Date Time.
     * Enrollment time of the device. This property is read-only.
     */
    @SerializedName(value = "enrolledDateTime", alternate = {"EnrolledDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime enrolledDateTime;

    /**
     * The Ethernet Mac Address.
     * Indicates Ethernet MAC Address of the device. Default, is Null (Non-Default property) for this property when returned as part of managedDevice entity. Individual get call with select query options is needed to retrieve actual values. Example: deviceManagement/managedDevices({managedDeviceId})?$select=ethernetMacAddress Supports: $select. $Search is not supported. Read-only. This property is read-only.
     */
    @SerializedName(value = "ethernetMacAddress", alternate = {"EthernetMacAddress"})
    @Expose
	@Nullable
    public String ethernetMacAddress;

    /**
     * The Exchange Access State.
     * The Access State of the device in Exchange. This property is read-only. Possible values are: none, unknown, allowed, blocked, quarantined.
     */
    @SerializedName(value = "exchangeAccessState", alternate = {"ExchangeAccessState"})
    @Expose
	@Nullable
    public DeviceManagementExchangeAccessState exchangeAccessState;

    /**
     * The Exchange Access State Reason.
     * The reason for the device's access state in Exchange. This property is read-only. Possible values are: none, unknown, exchangeGlobalRule, exchangeIndividualRule, exchangeDeviceRule, exchangeUpgrade, exchangeMailboxPolicy, other, compliant, notCompliant, notEnrolled, unknownLocation, mfaRequired, azureADBlockDueToAccessPolicy, compromisedPassword, deviceNotKnownWithManagedApp.
     */
    @SerializedName(value = "exchangeAccessStateReason", alternate = {"ExchangeAccessStateReason"})
    @Expose
	@Nullable
    public DeviceManagementExchangeAccessStateReason exchangeAccessStateReason;

    /**
     * The Exchange Last Successful Sync Date Time.
     * Last time the device contacted Exchange. This property is read-only.
     */
    @SerializedName(value = "exchangeLastSuccessfulSyncDateTime", alternate = {"ExchangeLastSuccessfulSyncDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime exchangeLastSuccessfulSyncDateTime;

    /**
     * The Free Storage Space In Bytes.
     * Free Storage in Bytes. Default value is 0. Read-only. This property is read-only.
     */
    @SerializedName(value = "freeStorageSpaceInBytes", alternate = {"FreeStorageSpaceInBytes"})
    @Expose
	@Nullable
    public Long freeStorageSpaceInBytes;

    /**
     * The Iccid.
     * Integrated Circuit Card Identifier, it is A SIM card's unique identification number. Return default value null in LIST managedDevices. Real value only returned in singel device GET call with device id and included in select parameter. Supports: $select. $Search is not supported. Read-only. This property is read-only.
     */
    @SerializedName(value = "iccid", alternate = {"Iccid"})
    @Expose
	@Nullable
    public String iccid;

    /**
     * The Imei.
     * IMEI. This property is read-only.
     */
    @SerializedName(value = "imei", alternate = {"Imei"})
    @Expose
	@Nullable
    public String imei;

    /**
     * The Is Encrypted.
     * Device encryption status. This property is read-only.
     */
    @SerializedName(value = "isEncrypted", alternate = {"IsEncrypted"})
    @Expose
	@Nullable
    public Boolean isEncrypted;

    /**
     * The Is Supervised.
     * Device supervised status. This property is read-only.
     */
    @SerializedName(value = "isSupervised", alternate = {"IsSupervised"})
    @Expose
	@Nullable
    public Boolean isSupervised;

    /**
     * The Jail Broken.
     * whether the device is jail broken or rooted. This property is read-only.
     */
    @SerializedName(value = "jailBroken", alternate = {"JailBroken"})
    @Expose
	@Nullable
    public String jailBroken;

    /**
     * The Last Sync Date Time.
     * The date and time that the device last completed a successful sync with Intune. This property is read-only.
     */
    @SerializedName(value = "lastSyncDateTime", alternate = {"LastSyncDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastSyncDateTime;

    /**
     * The Managed Device Name.
     * Automatically generated name to identify a device. Can be overwritten to a user friendly name.
     */
    @SerializedName(value = "managedDeviceName", alternate = {"ManagedDeviceName"})
    @Expose
	@Nullable
    public String managedDeviceName;

    /**
     * The Managed Device Owner Type.
     * Ownership of the device. Can be 'company' or 'personal'. Possible values are: unknown, company, personal.
     */
    @SerializedName(value = "managedDeviceOwnerType", alternate = {"ManagedDeviceOwnerType"})
    @Expose
	@Nullable
    public ManagedDeviceOwnerType managedDeviceOwnerType;

    /**
     * The Management Agent.
     * Management channel of the device. Intune, EAS, etc. This property is read-only. Possible values are: eas, mdm, easMdm, intuneClient, easIntuneClient, configurationManagerClient, configurationManagerClientMdm, configurationManagerClientMdmEas, unknown, jamf, googleCloudDevicePolicyController.
     */
    @SerializedName(value = "managementAgent", alternate = {"ManagementAgent"})
    @Expose
	@Nullable
    public ManagementAgentType managementAgent;

    /**
     * The Management Certificate Expiration Date.
     * Reports device management certificate expiration date. This property is read-only.
     */
    @SerializedName(value = "managementCertificateExpirationDate", alternate = {"ManagementCertificateExpirationDate"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime managementCertificateExpirationDate;

    /**
     * The Manufacturer.
     * Manufacturer of the device. This property is read-only.
     */
    @SerializedName(value = "manufacturer", alternate = {"Manufacturer"})
    @Expose
	@Nullable
    public String manufacturer;

    /**
     * The Meid.
     * MEID. This property is read-only.
     */
    @SerializedName(value = "meid", alternate = {"Meid"})
    @Expose
	@Nullable
    public String meid;

    /**
     * The Model.
     * Model of the device. This property is read-only.
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
	@Nullable
    public String model;

    /**
     * The Notes.
     * Notes on the device created by IT Admin. Return default value null in LIST managedDevices. Real value only returned in singel device GET call with device id and included in select parameter. Supports: $select.  $Search is not supported.
     */
    @SerializedName(value = "notes", alternate = {"Notes"})
    @Expose
	@Nullable
    public String notes;

    /**
     * The Operating System.
     * Operating system of the device. Windows, iOS, etc. This property is read-only.
     */
    @SerializedName(value = "operatingSystem", alternate = {"OperatingSystem"})
    @Expose
	@Nullable
    public String operatingSystem;

    /**
     * The Os Version.
     * Operating system version of the device. This property is read-only.
     */
    @SerializedName(value = "osVersion", alternate = {"OsVersion"})
    @Expose
	@Nullable
    public String osVersion;

    /**
     * The Partner Reported Threat State.
     * Indicates the threat state of a device when a Mobile Threat Defense partner is in use by the account and device. Read Only. This property is read-only. Possible values are: unknown, activated, deactivated, secured, lowSeverity, mediumSeverity, highSeverity, unresponsive, compromised, misconfigured.
     */
    @SerializedName(value = "partnerReportedThreatState", alternate = {"PartnerReportedThreatState"})
    @Expose
	@Nullable
    public ManagedDevicePartnerReportedHealthState partnerReportedThreatState;

    /**
     * The Phone Number.
     * Phone number of the device. This property is read-only.
     */
    @SerializedName(value = "phoneNumber", alternate = {"PhoneNumber"})
    @Expose
	@Nullable
    public String phoneNumber;

    /**
     * The Physical Memory In Bytes.
     * Total Memory in Bytes. Return default value 0 in LIST managedDevices. Real value only returned in singel device GET call with device id and included in select parameter. Supports: $select. Default value is 0. Read-only. This property is read-only.
     */
    @SerializedName(value = "physicalMemoryInBytes", alternate = {"PhysicalMemoryInBytes"})
    @Expose
	@Nullable
    public Long physicalMemoryInBytes;

    /**
     * The Remote Assistance Session Error Details.
     * An error string that identifies issues when creating Remote Assistance session objects. This property is read-only.
     */
    @SerializedName(value = "remoteAssistanceSessionErrorDetails", alternate = {"RemoteAssistanceSessionErrorDetails"})
    @Expose
	@Nullable
    public String remoteAssistanceSessionErrorDetails;

    /**
     * The Remote Assistance Session Url.
     * Url that allows a Remote Assistance session to be established with the device. This property is read-only.
     */
    @SerializedName(value = "remoteAssistanceSessionUrl", alternate = {"RemoteAssistanceSessionUrl"})
    @Expose
	@Nullable
    public String remoteAssistanceSessionUrl;

    /**
     * The Require User Enrollment Approval.
     * Reports if the managed iOS device is user approval enrollment. This property is read-only.
     */
    @SerializedName(value = "requireUserEnrollmentApproval", alternate = {"RequireUserEnrollmentApproval"})
    @Expose
	@Nullable
    public Boolean requireUserEnrollmentApproval;

    /**
     * The Serial Number.
     * SerialNumber. This property is read-only.
     */
    @SerializedName(value = "serialNumber", alternate = {"SerialNumber"})
    @Expose
	@Nullable
    public String serialNumber;

    /**
     * The Subscriber Carrier.
     * Subscriber Carrier. This property is read-only.
     */
    @SerializedName(value = "subscriberCarrier", alternate = {"SubscriberCarrier"})
    @Expose
	@Nullable
    public String subscriberCarrier;

    /**
     * The Total Storage Space In Bytes.
     * Total Storage in Bytes. This property is read-only.
     */
    @SerializedName(value = "totalStorageSpaceInBytes", alternate = {"TotalStorageSpaceInBytes"})
    @Expose
	@Nullable
    public Long totalStorageSpaceInBytes;

    /**
     * The Udid.
     * Unique Device Identifier for iOS and macOS devices. Return default value null in LIST managedDevices. Real value only returned in singel device GET call with device id and included in select parameter. Supports: $select. $Search is not supported. Read-only. This property is read-only.
     */
    @SerializedName(value = "udid", alternate = {"Udid"})
    @Expose
	@Nullable
    public String udid;

    /**
     * The User Display Name.
     * User display name. This property is read-only.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Id.
     * Unique Identifier for the user associated with the device. This property is read-only.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The User Principal Name.
     * Device user principal name. This property is read-only.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;

    /**
     * The Wi Fi Mac Address.
     * Wi-Fi MAC. This property is read-only.
     */
    @SerializedName(value = "wiFiMacAddress", alternate = {"WiFiMacAddress"})
    @Expose
	@Nullable
    public String wiFiMacAddress;

    /**
     * The Device Compliance Policy States.
     * Device compliance policy states for this device.
     */
    @SerializedName(value = "deviceCompliancePolicyStates", alternate = {"DeviceCompliancePolicyStates"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DeviceCompliancePolicyStateCollectionPage deviceCompliancePolicyStates;

    /**
     * The Device Configuration States.
     * Device configuration states for this device.
     */
    @SerializedName(value = "deviceConfigurationStates", alternate = {"DeviceConfigurationStates"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DeviceConfigurationStateCollectionPage deviceConfigurationStates;

    /**
     * The Device Category.
     * Device category
     */
    @SerializedName(value = "deviceCategory", alternate = {"DeviceCategory"})
    @Expose
	@Nullable
    public DeviceCategory deviceCategory;

    /**
     * The Users.
     * The primary users associated with the managed device.
     */
	@Nullable
    public com.microsoft.graph.requests.UserCollectionPage users;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("deviceCompliancePolicyStates")) {
            deviceCompliancePolicyStates = serializer.deserializeObject(json.get("deviceCompliancePolicyStates"), com.microsoft.graph.requests.DeviceCompliancePolicyStateCollectionPage.class);
        }

        if (json.has("deviceConfigurationStates")) {
            deviceConfigurationStates = serializer.deserializeObject(json.get("deviceConfigurationStates"), com.microsoft.graph.requests.DeviceConfigurationStateCollectionPage.class);
        }

        if (json.has("users")) {
            users = serializer.deserializeObject(json.get("users"), com.microsoft.graph.requests.UserCollectionPage.class);
        }
    }
}
