// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.CopyNotebookModel;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Get Notebook From Web Url Parameter Set.
 */
public class NotebookGetNotebookFromWebUrlParameterSet {
    /**
     * The web Url.
     * 
     */
    @SerializedName(value = "webUrl", alternate = {"WebUrl"})
    @Expose
	@Nullable
    public String webUrl;


    /**
     * Instiaciates a new NotebookGetNotebookFromWebUrlParameterSet
     */
    public NotebookGetNotebookFromWebUrlParameterSet() {}
    /**
     * Instiaciates a new NotebookGetNotebookFromWebUrlParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected NotebookGetNotebookFromWebUrlParameterSet(@Nonnull final NotebookGetNotebookFromWebUrlParameterSetBuilder builder) {
        this.webUrl = builder.webUrl;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static NotebookGetNotebookFromWebUrlParameterSetBuilder newBuilder() {
        return new NotebookGetNotebookFromWebUrlParameterSetBuilder();
    }
    /**
     * Fluent builder for the NotebookGetNotebookFromWebUrlParameterSet
     */
    public static final class NotebookGetNotebookFromWebUrlParameterSetBuilder {
        /**
         * The webUrl parameter value
         */
        @Nullable
        protected String webUrl;
        /**
         * Sets the WebUrl
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public NotebookGetNotebookFromWebUrlParameterSetBuilder withWebUrl(@Nullable final String val) {
            this.webUrl = val;
            return this;
        }
        /**
         * Instanciates a new NotebookGetNotebookFromWebUrlParameterSetBuilder
         */
        @Nullable
        protected NotebookGetNotebookFromWebUrlParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public NotebookGetNotebookFromWebUrlParameterSet build() {
            return new NotebookGetNotebookFromWebUrlParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.webUrl != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("webUrl", webUrl));
        }
        return result;
    }
}
