// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.CasesRoot;
import com.microsoft.graph.models.AttackSimulationRoot;
import com.microsoft.graph.security.models.TriggersRoot;
import com.microsoft.graph.security.models.TriggerTypesRoot;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.security.requests.IncidentCollectionPage;
import com.microsoft.graph.requests.SecureScoreControlProfileCollectionPage;
import com.microsoft.graph.requests.SecureScoreCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Security.
 */
public class Security extends Entity implements IJsonBackedObject {


    /**
     * The Cases.
     * 
     */
    @SerializedName(value = "cases", alternate = {"Cases"})
    @Expose
	@Nullable
    public CasesRoot cases;

    /**
     * The Alerts_v2.
     * A collection of alerts in Microsoft 365 Defender.
     */
    @SerializedName(value = "alerts_v2", alternate = {"Alerts_v2"})
    @Expose
	@Nullable
    public com.microsoft.graph.security.requests.AlertCollectionPage alerts_v2;

    /**
     * The Incidents.
     * A collection of incidents in Microsoft 365 Defender, each of which is a set of correlated alerts and associated metadata that reflects the story of an attack.
     */
    @SerializedName(value = "incidents", alternate = {"Incidents"})
    @Expose
	@Nullable
    public com.microsoft.graph.security.requests.IncidentCollectionPage incidents;

    /**
     * The Attack Simulation.
     * 
     */
    @SerializedName(value = "attackSimulation", alternate = {"AttackSimulation"})
    @Expose
	@Nullable
    public AttackSimulationRoot attackSimulation;

    /**
     * The Triggers.
     * 
     */
    @SerializedName(value = "triggers", alternate = {"Triggers"})
    @Expose
	@Nullable
    public TriggersRoot triggers;

    /**
     * The Trigger Types.
     * 
     */
    @SerializedName(value = "triggerTypes", alternate = {"TriggerTypes"})
    @Expose
	@Nullable
    public TriggerTypesRoot triggerTypes;

    /**
     * The Alerts.
     * 
     */
    @SerializedName(value = "alerts", alternate = {"Alerts"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AlertCollectionPage alerts;

    /**
     * The Secure Score Control Profiles.
     * 
     */
    @SerializedName(value = "secureScoreControlProfiles", alternate = {"SecureScoreControlProfiles"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.SecureScoreControlProfileCollectionPage secureScoreControlProfiles;

    /**
     * The Secure Scores.
     * 
     */
    @SerializedName(value = "secureScores", alternate = {"SecureScores"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.SecureScoreCollectionPage secureScores;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("alerts_v2")) {
            alerts_v2 = serializer.deserializeObject(json.get("alerts_v2"), com.microsoft.graph.security.requests.AlertCollectionPage.class);
        }

        if (json.has("incidents")) {
            incidents = serializer.deserializeObject(json.get("incidents"), com.microsoft.graph.security.requests.IncidentCollectionPage.class);
        }

        if (json.has("alerts")) {
            alerts = serializer.deserializeObject(json.get("alerts"), com.microsoft.graph.requests.AlertCollectionPage.class);
        }

        if (json.has("secureScoreControlProfiles")) {
            secureScoreControlProfiles = serializer.deserializeObject(json.get("secureScoreControlProfiles"), com.microsoft.graph.requests.SecureScoreControlProfileCollectionPage.class);
        }

        if (json.has("secureScores")) {
            secureScores = serializer.deserializeObject(json.get("secureScores"), com.microsoft.graph.requests.SecureScoreCollectionPage.class);
        }
    }
}
