// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Site;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Get By Path Parameter Set.
 */
public class SiteGetByPathParameterSet {
    /**
     * The path.
     * 
     */
    @SerializedName(value = "path", alternate = {"Path"})
    @Expose
	@Nullable
    public String path;


    /**
     * Instiaciates a new SiteGetByPathParameterSet
     */
    public SiteGetByPathParameterSet() {}
    /**
     * Instiaciates a new SiteGetByPathParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SiteGetByPathParameterSet(@Nonnull final SiteGetByPathParameterSetBuilder builder) {
        this.path = builder.path;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SiteGetByPathParameterSetBuilder newBuilder() {
        return new SiteGetByPathParameterSetBuilder();
    }
    /**
     * Fluent builder for the SiteGetByPathParameterSet
     */
    public static final class SiteGetByPathParameterSetBuilder {
        /**
         * The path parameter value
         */
        @Nullable
        protected String path;
        /**
         * Sets the Path
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SiteGetByPathParameterSetBuilder withPath(@Nullable final String val) {
            this.path = val;
            return this;
        }
        /**
         * Instanciates a new SiteGetByPathParameterSetBuilder
         */
        @Nullable
        protected SiteGetByPathParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SiteGetByPathParameterSet build() {
            return new SiteGetByPathParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.path != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("path", path));
        }
        return result;
    }
}
