// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DayOfWeek;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Standard Time Zone Offset.
 */
public class StandardTimeZoneOffset implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Day Occurrence.
     * Represents the nth occurrence of the day of week that the transition from daylight saving time to standard time occurs.
     */
    @SerializedName(value = "dayOccurrence", alternate = {"DayOccurrence"})
    @Expose
	@Nullable
    public Integer dayOccurrence;

    /**
     * The Day Of Week.
     * Represents the day of the week when the transition from daylight saving time to standard time.
     */
    @SerializedName(value = "dayOfWeek", alternate = {"DayOfWeek"})
    @Expose
	@Nullable
    public DayOfWeek dayOfWeek;

    /**
     * The Month.
     * Represents the month of the year when the transition from daylight saving time to standard time occurs.
     */
    @SerializedName(value = "month", alternate = {"Month"})
    @Expose
	@Nullable
    public Integer month;

    /**
     * The Time.
     * Represents the time of day when the transition from daylight saving time to standard time occurs.
     */
    @SerializedName(value = "time", alternate = {"Time"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.TimeOfDay time;

    /**
     * The Year.
     * Represents how frequently in terms of years the change from daylight saving time to standard time occurs. For example, a value of 0 means every year.
     */
    @SerializedName(value = "year", alternate = {"Year"})
    @Expose
	@Nullable
    public Integer year;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
