// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookChart;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Add Parameter Set.
 */
public class WorkbookChartAddParameterSet {
    /**
     * The type.
     * 
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public String type;

    /**
     * The source Data.
     * 
     */
    @SerializedName(value = "sourceData", alternate = {"SourceData"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement sourceData;

    /**
     * The series By.
     * 
     */
    @SerializedName(value = "seriesBy", alternate = {"SeriesBy"})
    @Expose
	@Nullable
    public String seriesBy;


    /**
     * Instiaciates a new WorkbookChartAddParameterSet
     */
    public WorkbookChartAddParameterSet() {}
    /**
     * Instiaciates a new WorkbookChartAddParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookChartAddParameterSet(@Nonnull final WorkbookChartAddParameterSetBuilder builder) {
        this.type = builder.type;
        this.sourceData = builder.sourceData;
        this.seriesBy = builder.seriesBy;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookChartAddParameterSetBuilder newBuilder() {
        return new WorkbookChartAddParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookChartAddParameterSet
     */
    public static final class WorkbookChartAddParameterSetBuilder {
        /**
         * The type parameter value
         */
        @Nullable
        protected String type;
        /**
         * Sets the Type
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartAddParameterSetBuilder withType(@Nullable final String val) {
            this.type = val;
            return this;
        }
        /**
         * The sourceData parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement sourceData;
        /**
         * Sets the SourceData
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartAddParameterSetBuilder withSourceData(@Nullable final com.google.gson.JsonElement val) {
            this.sourceData = val;
            return this;
        }
        /**
         * The seriesBy parameter value
         */
        @Nullable
        protected String seriesBy;
        /**
         * Sets the SeriesBy
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartAddParameterSetBuilder withSeriesBy(@Nullable final String val) {
            this.seriesBy = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookChartAddParameterSetBuilder
         */
        @Nullable
        protected WorkbookChartAddParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookChartAddParameterSet build() {
            return new WorkbookChartAddParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.type != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("type", type));
        }
        if(this.sourceData != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sourceData", sourceData));
        }
        if(this.seriesBy != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("seriesBy", seriesBy));
        }
        return result;
    }
}
