// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignmentRequest;
import com.microsoft.graph.models.AccessPackageAssignmentRequestFilterByCurrentUserOptions;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Request Request.
 */
public class AccessPackageAssignmentRequestRequest extends BaseRequest<AccessPackageAssignmentRequest> {
	
    /**
     * The request for the AccessPackageAssignmentRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentRequest.class);
    }

    /**
     * Gets the AccessPackageAssignmentRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageAssignmentRequest from the service
     *
     * @return the AccessPackageAssignmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageAssignmentRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageAssignmentRequest with a source
     *
     * @param sourceAccessPackageAssignmentRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequest> patchAsync(@Nonnull final AccessPackageAssignmentRequest sourceAccessPackageAssignmentRequest) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageAssignmentRequest);
    }

    /**
     * Patches this AccessPackageAssignmentRequest with a source
     *
     * @param sourceAccessPackageAssignmentRequest the source object with updates
     * @return the updated AccessPackageAssignmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequest patch(@Nonnull final AccessPackageAssignmentRequest sourceAccessPackageAssignmentRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageAssignmentRequest);
    }

    /**
     * Creates a AccessPackageAssignmentRequest with a new object
     *
     * @param newAccessPackageAssignmentRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequest> postAsync(@Nonnull final AccessPackageAssignmentRequest newAccessPackageAssignmentRequest) {
        return sendAsync(HttpMethod.POST, newAccessPackageAssignmentRequest);
    }

    /**
     * Creates a AccessPackageAssignmentRequest with a new object
     *
     * @param newAccessPackageAssignmentRequest the new object to create
     * @return the created AccessPackageAssignmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequest post(@Nonnull final AccessPackageAssignmentRequest newAccessPackageAssignmentRequest) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageAssignmentRequest);
    }

    /**
     * Creates a AccessPackageAssignmentRequest with a new object
     *
     * @param newAccessPackageAssignmentRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentRequest> putAsync(@Nonnull final AccessPackageAssignmentRequest newAccessPackageAssignmentRequest) {
        return sendAsync(HttpMethod.PUT, newAccessPackageAssignmentRequest);
    }

    /**
     * Creates a AccessPackageAssignmentRequest with a new object
     *
     * @param newAccessPackageAssignmentRequest the object to create/update
     * @return the created AccessPackageAssignmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentRequest put(@Nonnull final AccessPackageAssignmentRequest newAccessPackageAssignmentRequest) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageAssignmentRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

