// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationContextClassReference;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Context Class Reference Request.
 */
public class AuthenticationContextClassReferenceRequest extends BaseRequest<AuthenticationContextClassReference> {
	
    /**
     * The request for the AuthenticationContextClassReference
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationContextClassReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationContextClassReference.class);
    }

    /**
     * Gets the AuthenticationContextClassReference from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationContextClassReference> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationContextClassReference from the service
     *
     * @return the AuthenticationContextClassReference from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationContextClassReference get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationContextClassReference> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationContextClassReference delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationContextClassReference with a source
     *
     * @param sourceAuthenticationContextClassReference the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationContextClassReference> patchAsync(@Nonnull final AuthenticationContextClassReference sourceAuthenticationContextClassReference) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationContextClassReference);
    }

    /**
     * Patches this AuthenticationContextClassReference with a source
     *
     * @param sourceAuthenticationContextClassReference the source object with updates
     * @return the updated AuthenticationContextClassReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationContextClassReference patch(@Nonnull final AuthenticationContextClassReference sourceAuthenticationContextClassReference) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationContextClassReference);
    }

    /**
     * Creates a AuthenticationContextClassReference with a new object
     *
     * @param newAuthenticationContextClassReference the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationContextClassReference> postAsync(@Nonnull final AuthenticationContextClassReference newAuthenticationContextClassReference) {
        return sendAsync(HttpMethod.POST, newAuthenticationContextClassReference);
    }

    /**
     * Creates a AuthenticationContextClassReference with a new object
     *
     * @param newAuthenticationContextClassReference the new object to create
     * @return the created AuthenticationContextClassReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationContextClassReference post(@Nonnull final AuthenticationContextClassReference newAuthenticationContextClassReference) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationContextClassReference);
    }

    /**
     * Creates a AuthenticationContextClassReference with a new object
     *
     * @param newAuthenticationContextClassReference the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationContextClassReference> putAsync(@Nonnull final AuthenticationContextClassReference newAuthenticationContextClassReference) {
        return sendAsync(HttpMethod.PUT, newAuthenticationContextClassReference);
    }

    /**
     * Creates a AuthenticationContextClassReference with a new object
     *
     * @param newAuthenticationContextClassReference the object to create/update
     * @return the created AuthenticationContextClassReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationContextClassReference put(@Nonnull final AuthenticationContextClassReference newAuthenticationContextClassReference) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationContextClassReference);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationContextClassReferenceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationContextClassReferenceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

