// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingCustomer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Customer Request.
 */
public class BookingCustomerRequest extends BaseRequest<BookingCustomer> {
	
    /**
     * The request for the BookingCustomer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingCustomerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingCustomer.class);
    }

    /**
     * Gets the BookingCustomer from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingCustomer> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BookingCustomer from the service
     *
     * @return the BookingCustomer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingCustomer get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingCustomer> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BookingCustomer delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BookingCustomer with a source
     *
     * @param sourceBookingCustomer the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingCustomer> patchAsync(@Nonnull final BookingCustomer sourceBookingCustomer) {
        return sendAsync(HttpMethod.PATCH, sourceBookingCustomer);
    }

    /**
     * Patches this BookingCustomer with a source
     *
     * @param sourceBookingCustomer the source object with updates
     * @return the updated BookingCustomer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingCustomer patch(@Nonnull final BookingCustomer sourceBookingCustomer) throws ClientException {
        return send(HttpMethod.PATCH, sourceBookingCustomer);
    }

    /**
     * Creates a BookingCustomer with a new object
     *
     * @param newBookingCustomer the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingCustomer> postAsync(@Nonnull final BookingCustomer newBookingCustomer) {
        return sendAsync(HttpMethod.POST, newBookingCustomer);
    }

    /**
     * Creates a BookingCustomer with a new object
     *
     * @param newBookingCustomer the new object to create
     * @return the created BookingCustomer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingCustomer post(@Nonnull final BookingCustomer newBookingCustomer) throws ClientException {
        return send(HttpMethod.POST, newBookingCustomer);
    }

    /**
     * Creates a BookingCustomer with a new object
     *
     * @param newBookingCustomer the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingCustomer> putAsync(@Nonnull final BookingCustomer newBookingCustomer) {
        return sendAsync(HttpMethod.PUT, newBookingCustomer);
    }

    /**
     * Creates a BookingCustomer with a new object
     *
     * @param newBookingCustomer the object to create/update
     * @return the created BookingCustomer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingCustomer put(@Nonnull final BookingCustomer newBookingCustomer) throws ClientException {
        return send(HttpMethod.PUT, newBookingCustomer);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BookingCustomerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BookingCustomerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

