// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.CallAddLargeGalleryViewRequest;
import com.microsoft.graph.models.Call;
import com.microsoft.graph.models.AddLargeGalleryViewOperation;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.CallAddLargeGalleryViewParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Add Large Gallery View Request Builder.
 */
public class CallAddLargeGalleryViewRequestBuilder extends BaseActionRequestBuilder<AddLargeGalleryViewOperation> {

    /**
     * The request builder for this CallAddLargeGalleryView
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallAddLargeGalleryViewRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private CallAddLargeGalleryViewParameterSet body;
    /**
     * The request builder for this CallAddLargeGalleryView
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public CallAddLargeGalleryViewRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final CallAddLargeGalleryViewParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the CallAddLargeGalleryViewRequest
     *
     * @param requestOptions the options for the request
     * @return the CallAddLargeGalleryViewRequest instance
     */
    @Nonnull
    public CallAddLargeGalleryViewRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the CallAddLargeGalleryViewRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the CallAddLargeGalleryViewRequest instance
     */
    @Nonnull
    public CallAddLargeGalleryViewRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final CallAddLargeGalleryViewRequest request = new CallAddLargeGalleryViewRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
