// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ChatMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Request Builder.
 */
public class ChatMessageRequestBuilder extends BaseRequestBuilder<ChatMessage> {

    /**
     * The request builder for the ChatMessage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChatMessageRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ChatMessageRequest instance
     */
    @Nonnull
    public ChatMessageRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ChatMessageRequest instance
     */
    @Nonnull
    public ChatMessageRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.ChatMessageRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the ChatMessageHostedContent collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageHostedContentCollectionRequestBuilder hostedContents() {
        return new com.microsoft.graph.requests.ChatMessageHostedContentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("hostedContents"), getClient(), null);
    }

    /**
     * Gets a request builder for the ChatMessageHostedContent item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageHostedContentRequestBuilder hostedContents(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChatMessageHostedContentRequestBuilder(getRequestUrlWithAdditionalSegment("hostedContents") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ChatMessage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder replies() {
        return new com.microsoft.graph.requests.ChatMessageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("replies"), getClient(), null);
    }

    /**
     * Gets a request builder for the ChatMessage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatMessageRequestBuilder replies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChatMessageRequestBuilder(getRequestUrlWithAdditionalSegment("replies") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ChatMessageSoftDeleteRequestBuilder softDelete() {
        return new ChatMessageSoftDeleteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.softDelete"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ChatMessageUndoSoftDeleteRequestBuilder undoSoftDelete() {
        return new ChatMessageUndoSoftDeleteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.undoSoftDelete"), getClient(), null);
    }
}
