// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Presence;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.requests.CloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder;
import com.microsoft.graph.requests.CloudCommunicationsGetPresencesByUserIdCollectionPage;
import com.microsoft.graph.requests.CloudCommunicationsGetPresencesByUserIdCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cloud Communications Get Presences By User Id Collection Page.
 */
public class CloudCommunicationsGetPresencesByUserIdCollectionPage extends BaseCollectionPage<Presence, CloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder> {

    /**
     * A collection page for Presence.
     *
     * @param response The serialized CloudCommunicationsGetPresencesByUserIdCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public CloudCommunicationsGetPresencesByUserIdCollectionPage(@Nonnull final CloudCommunicationsGetPresencesByUserIdCollectionResponse response, @Nonnull final CloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for CloudCommunicationsGetPresencesByUserId
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public CloudCommunicationsGetPresencesByUserIdCollectionPage(@Nonnull final java.util.List<Presence> pageContents, @Nullable final CloudCommunicationsGetPresencesByUserIdCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
