// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SharedWithChannelTeamInfo;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.ActionResultPart;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ConversationMemberCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberCollectionWithReferencesPage;
import com.microsoft.graph.requests.ConversationMemberCollectionResponse;
import com.microsoft.graph.models.ConversationMember;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conversation Member Collection With References Page.
 */
public class ConversationMemberCollectionWithReferencesPage extends BaseCollectionPage<ConversationMember, ConversationMemberCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for ConversationMember
     *
     * @param response the serialized ConversationMemberCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ConversationMemberCollectionWithReferencesPage(@Nonnull final ConversationMemberCollectionResponse response, @Nullable final ConversationMemberCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for ConversationMember
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ConversationMemberCollectionWithReferencesPage(@Nonnull final java.util.List<ConversationMember> pageContents, @Nullable final ConversationMemberCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
