// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceManagementExportJob;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Export Job Request.
 */
public class DeviceManagementExportJobRequest extends BaseRequest<DeviceManagementExportJob> {
	
    /**
     * The request for the DeviceManagementExportJob
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceManagementExportJobRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementExportJob.class);
    }

    /**
     * Gets the DeviceManagementExportJob from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExportJob> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceManagementExportJob from the service
     *
     * @return the DeviceManagementExportJob from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExportJob get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExportJob> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceManagementExportJob delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceManagementExportJob with a source
     *
     * @param sourceDeviceManagementExportJob the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExportJob> patchAsync(@Nonnull final DeviceManagementExportJob sourceDeviceManagementExportJob) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceManagementExportJob);
    }

    /**
     * Patches this DeviceManagementExportJob with a source
     *
     * @param sourceDeviceManagementExportJob the source object with updates
     * @return the updated DeviceManagementExportJob
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExportJob patch(@Nonnull final DeviceManagementExportJob sourceDeviceManagementExportJob) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceManagementExportJob);
    }

    /**
     * Creates a DeviceManagementExportJob with a new object
     *
     * @param newDeviceManagementExportJob the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExportJob> postAsync(@Nonnull final DeviceManagementExportJob newDeviceManagementExportJob) {
        return sendAsync(HttpMethod.POST, newDeviceManagementExportJob);
    }

    /**
     * Creates a DeviceManagementExportJob with a new object
     *
     * @param newDeviceManagementExportJob the new object to create
     * @return the created DeviceManagementExportJob
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExportJob post(@Nonnull final DeviceManagementExportJob newDeviceManagementExportJob) throws ClientException {
        return send(HttpMethod.POST, newDeviceManagementExportJob);
    }

    /**
     * Creates a DeviceManagementExportJob with a new object
     *
     * @param newDeviceManagementExportJob the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementExportJob> putAsync(@Nonnull final DeviceManagementExportJob newDeviceManagementExportJob) {
        return sendAsync(HttpMethod.PUT, newDeviceManagementExportJob);
    }

    /**
     * Creates a DeviceManagementExportJob with a new object
     *
     * @param newDeviceManagementExportJob the object to create/update
     * @return the created DeviceManagementExportJob
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementExportJob put(@Nonnull final DeviceManagementExportJob newDeviceManagementExportJob) throws ClientException {
        return send(HttpMethod.PUT, newDeviceManagementExportJob);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementExportJobRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementExportJobRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

