// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OpenShift;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Open Shift Request.
 */
public class OpenShiftRequest extends BaseRequest<OpenShift> {
	
    /**
     * The request for the OpenShift
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OpenShiftRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShift.class);
    }

    /**
     * Gets the OpenShift from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShift> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OpenShift from the service
     *
     * @return the OpenShift from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShift get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShift> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OpenShift delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OpenShift with a source
     *
     * @param sourceOpenShift the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShift> patchAsync(@Nonnull final OpenShift sourceOpenShift) {
        return sendAsync(HttpMethod.PATCH, sourceOpenShift);
    }

    /**
     * Patches this OpenShift with a source
     *
     * @param sourceOpenShift the source object with updates
     * @return the updated OpenShift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShift patch(@Nonnull final OpenShift sourceOpenShift) throws ClientException {
        return send(HttpMethod.PATCH, sourceOpenShift);
    }

    /**
     * Creates a OpenShift with a new object
     *
     * @param newOpenShift the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShift> postAsync(@Nonnull final OpenShift newOpenShift) {
        return sendAsync(HttpMethod.POST, newOpenShift);
    }

    /**
     * Creates a OpenShift with a new object
     *
     * @param newOpenShift the new object to create
     * @return the created OpenShift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShift post(@Nonnull final OpenShift newOpenShift) throws ClientException {
        return send(HttpMethod.POST, newOpenShift);
    }

    /**
     * Creates a OpenShift with a new object
     *
     * @param newOpenShift the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OpenShift> putAsync(@Nonnull final OpenShift newOpenShift) {
        return sendAsync(HttpMethod.PUT, newOpenShift);
    }

    /**
     * Creates a OpenShift with a new object
     *
     * @param newOpenShift the object to create/update
     * @return the created OpenShift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OpenShift put(@Nonnull final OpenShift newOpenShift) throws ClientException {
        return send(HttpMethod.PUT, newOpenShift);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OpenShiftRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OpenShiftRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

