// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OrganizationalBrandingProperties;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Properties Request.
 */
public class OrganizationalBrandingPropertiesRequest extends BaseRequest<OrganizationalBrandingProperties> {
	
    /**
     * The request for the OrganizationalBrandingProperties
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public OrganizationalBrandingPropertiesRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends OrganizationalBrandingProperties> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the OrganizationalBrandingProperties
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationalBrandingPropertiesRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrganizationalBrandingProperties.class);
    }

    /**
     * Gets the OrganizationalBrandingProperties from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingProperties> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the OrganizationalBrandingProperties from the service
     *
     * @return the OrganizationalBrandingProperties from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingProperties get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingProperties> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public OrganizationalBrandingProperties delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OrganizationalBrandingProperties with a source
     *
     * @param sourceOrganizationalBrandingProperties the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingProperties> patchAsync(@Nonnull final OrganizationalBrandingProperties sourceOrganizationalBrandingProperties) {
        return sendAsync(HttpMethod.PATCH, sourceOrganizationalBrandingProperties);
    }

    /**
     * Patches this OrganizationalBrandingProperties with a source
     *
     * @param sourceOrganizationalBrandingProperties the source object with updates
     * @return the updated OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingProperties patch(@Nonnull final OrganizationalBrandingProperties sourceOrganizationalBrandingProperties) throws ClientException {
        return send(HttpMethod.PATCH, sourceOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingProperties> postAsync(@Nonnull final OrganizationalBrandingProperties newOrganizationalBrandingProperties) {
        return sendAsync(HttpMethod.POST, newOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the new object to create
     * @return the created OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingProperties post(@Nonnull final OrganizationalBrandingProperties newOrganizationalBrandingProperties) throws ClientException {
        return send(HttpMethod.POST, newOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<OrganizationalBrandingProperties> putAsync(@Nonnull final OrganizationalBrandingProperties newOrganizationalBrandingProperties) {
        return sendAsync(HttpMethod.PUT, newOrganizationalBrandingProperties);
    }

    /**
     * Creates a OrganizationalBrandingProperties with a new object
     *
     * @param newOrganizationalBrandingProperties the object to create/update
     * @return the created OrganizationalBrandingProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public OrganizationalBrandingProperties put(@Nonnull final OrganizationalBrandingProperties newOrganizationalBrandingProperties) throws ClientException {
        return send(HttpMethod.PUT, newOrganizationalBrandingProperties);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OrganizationalBrandingPropertiesRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OrganizationalBrandingPropertiesRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

