// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PolicyRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Policy Root Request Builder.
 */
public class PolicyRootRequestBuilder extends BaseRequestBuilder<PolicyRoot> {

    /**
     * The request builder for the PolicyRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PolicyRootRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PolicyRootRequest instance
     */
    @Nonnull
    public PolicyRootRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PolicyRootRequest instance
     */
    @Nonnull
    public PolicyRootRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.PolicyRootRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for AuthenticationMethodsPolicy
     *
     * @return the AuthenticationMethodsPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodsPolicyRequestBuilder authenticationMethodsPolicy() {
        return new com.microsoft.graph.requests.AuthenticationMethodsPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationMethodsPolicy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the AuthenticationStrengthPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionRequestBuilder authenticationStrengthPolicies() {
        return new com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationStrengthPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the AuthenticationStrengthPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationStrengthPolicyRequestBuilder authenticationStrengthPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AuthenticationStrengthPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationStrengthPolicies") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for AuthenticationFlowsPolicy
     *
     * @return the AuthenticationFlowsPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationFlowsPolicyRequestBuilder authenticationFlowsPolicy() {
        return new com.microsoft.graph.requests.AuthenticationFlowsPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("authenticationFlowsPolicy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ActivityBasedTimeoutPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ActivityBasedTimeoutPolicyCollectionRequestBuilder activityBasedTimeoutPolicies() {
        return new com.microsoft.graph.requests.ActivityBasedTimeoutPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("activityBasedTimeoutPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the ActivityBasedTimeoutPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ActivityBasedTimeoutPolicyRequestBuilder activityBasedTimeoutPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ActivityBasedTimeoutPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("activityBasedTimeoutPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the AppManagementPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.AppManagementPolicyCollectionRequestBuilder appManagementPolicies() {
        return new com.microsoft.graph.requests.AppManagementPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("appManagementPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the AppManagementPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.AppManagementPolicyRequestBuilder appManagementPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AppManagementPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("appManagementPolicies") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for AuthorizationPolicy
     *
     * @return the AuthorizationPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthorizationPolicyRequestBuilder authorizationPolicy() {
        return new com.microsoft.graph.requests.AuthorizationPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("authorizationPolicy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ClaimsMappingPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ClaimsMappingPolicyCollectionRequestBuilder claimsMappingPolicies() {
        return new com.microsoft.graph.requests.ClaimsMappingPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("claimsMappingPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the ClaimsMappingPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ClaimsMappingPolicyRequestBuilder claimsMappingPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ClaimsMappingPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("claimsMappingPolicies") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for CrossTenantAccessPolicy
     *
     * @return the CrossTenantAccessPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.CrossTenantAccessPolicyRequestBuilder crossTenantAccessPolicy() {
        return new com.microsoft.graph.requests.CrossTenantAccessPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("crossTenantAccessPolicy"), getClient(), null);
    }

    /**
     * Gets the request builder for TenantAppManagementPolicy
     *
     * @return the TenantAppManagementPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.TenantAppManagementPolicyRequestBuilder defaultAppManagementPolicy() {
        return new com.microsoft.graph.requests.TenantAppManagementPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("defaultAppManagementPolicy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the HomeRealmDiscoveryPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.HomeRealmDiscoveryPolicyCollectionRequestBuilder homeRealmDiscoveryPolicies() {
        return new com.microsoft.graph.requests.HomeRealmDiscoveryPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("homeRealmDiscoveryPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the HomeRealmDiscoveryPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.HomeRealmDiscoveryPolicyRequestBuilder homeRealmDiscoveryPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.HomeRealmDiscoveryPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("homeRealmDiscoveryPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PermissionGrantPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PermissionGrantPolicyCollectionRequestBuilder permissionGrantPolicies() {
        return new com.microsoft.graph.requests.PermissionGrantPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("permissionGrantPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the PermissionGrantPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PermissionGrantPolicyRequestBuilder permissionGrantPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PermissionGrantPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("permissionGrantPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TokenIssuancePolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TokenIssuancePolicyCollectionRequestBuilder tokenIssuancePolicies() {
        return new com.microsoft.graph.requests.TokenIssuancePolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tokenIssuancePolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the TokenIssuancePolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TokenIssuancePolicyRequestBuilder tokenIssuancePolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TokenIssuancePolicyRequestBuilder(getRequestUrlWithAdditionalSegment("tokenIssuancePolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TokenLifetimePolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TokenLifetimePolicyCollectionRequestBuilder tokenLifetimePolicies() {
        return new com.microsoft.graph.requests.TokenLifetimePolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tokenLifetimePolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the TokenLifetimePolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TokenLifetimePolicyRequestBuilder tokenLifetimePolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TokenLifetimePolicyRequestBuilder(getRequestUrlWithAdditionalSegment("tokenLifetimePolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the FeatureRolloutPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.FeatureRolloutPolicyCollectionRequestBuilder featureRolloutPolicies() {
        return new com.microsoft.graph.requests.FeatureRolloutPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("featureRolloutPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the FeatureRolloutPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.FeatureRolloutPolicyRequestBuilder featureRolloutPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.FeatureRolloutPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("featureRolloutPolicies") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for AdminConsentRequestPolicy
     *
     * @return the AdminConsentRequestPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.AdminConsentRequestPolicyRequestBuilder adminConsentRequestPolicy() {
        return new com.microsoft.graph.requests.AdminConsentRequestPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("adminConsentRequestPolicy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ConditionalAccessPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ConditionalAccessPolicyCollectionRequestBuilder conditionalAccessPolicies() {
        return new com.microsoft.graph.requests.ConditionalAccessPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("conditionalAccessPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the ConditionalAccessPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ConditionalAccessPolicyRequestBuilder conditionalAccessPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ConditionalAccessPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("conditionalAccessPolicies") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for IdentitySecurityDefaultsEnforcementPolicy
     *
     * @return the IdentitySecurityDefaultsEnforcementPolicyRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentitySecurityDefaultsEnforcementPolicyRequestBuilder identitySecurityDefaultsEnforcementPolicy() {
        return new com.microsoft.graph.requests.IdentitySecurityDefaultsEnforcementPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("identitySecurityDefaultsEnforcementPolicy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleManagementPolicy collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleManagementPolicyCollectionRequestBuilder roleManagementPolicies() {
        return new com.microsoft.graph.requests.UnifiedRoleManagementPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleManagementPolicies"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleManagementPolicy item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleManagementPolicyRequestBuilder roleManagementPolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleManagementPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("roleManagementPolicies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedRoleManagementPolicyAssignment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleManagementPolicyAssignmentCollectionRequestBuilder roleManagementPolicyAssignments() {
        return new com.microsoft.graph.requests.UnifiedRoleManagementPolicyAssignmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("roleManagementPolicyAssignments"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedRoleManagementPolicyAssignment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UnifiedRoleManagementPolicyAssignmentRequestBuilder roleManagementPolicyAssignments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UnifiedRoleManagementPolicyAssignmentRequestBuilder(getRequestUrlWithAdditionalSegment("roleManagementPolicyAssignments") + "/" + id, getClient(), null);
    }
}
