// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Privacy;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privacy Request.
 */
public class PrivacyRequest extends BaseRequest<Privacy> {
	
    /**
     * The request for the Privacy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrivacyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Privacy.class);
    }

    /**
     * Gets the Privacy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Privacy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Privacy from the service
     *
     * @return the Privacy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Privacy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Privacy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Privacy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Privacy with a source
     *
     * @param sourcePrivacy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Privacy> patchAsync(@Nonnull final Privacy sourcePrivacy) {
        return sendAsync(HttpMethod.PATCH, sourcePrivacy);
    }

    /**
     * Patches this Privacy with a source
     *
     * @param sourcePrivacy the source object with updates
     * @return the updated Privacy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Privacy patch(@Nonnull final Privacy sourcePrivacy) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrivacy);
    }

    /**
     * Creates a Privacy with a new object
     *
     * @param newPrivacy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Privacy> postAsync(@Nonnull final Privacy newPrivacy) {
        return sendAsync(HttpMethod.POST, newPrivacy);
    }

    /**
     * Creates a Privacy with a new object
     *
     * @param newPrivacy the new object to create
     * @return the created Privacy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Privacy post(@Nonnull final Privacy newPrivacy) throws ClientException {
        return send(HttpMethod.POST, newPrivacy);
    }

    /**
     * Creates a Privacy with a new object
     *
     * @param newPrivacy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Privacy> putAsync(@Nonnull final Privacy newPrivacy) {
        return sendAsync(HttpMethod.PUT, newPrivacy);
    }

    /**
     * Creates a Privacy with a new object
     *
     * @param newPrivacy the object to create/update
     * @return the created Privacy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Privacy put(@Nonnull final Privacy newPrivacy) throws ClientException {
        return send(HttpMethod.PUT, newPrivacy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrivacyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrivacyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

