// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SecurityReportsRoot;
import com.microsoft.graph.models.AttackSimulationRepeatOffender;
import com.microsoft.graph.models.AttackSimulationSimulationUserCoverage;
import com.microsoft.graph.models.AttackSimulationTrainingUserCoverage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Security Reports Root Request.
 */
public class SecurityReportsRootRequest extends BaseRequest<SecurityReportsRoot> {
	
    /**
     * The request for the SecurityReportsRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SecurityReportsRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecurityReportsRoot.class);
    }

    /**
     * Gets the SecurityReportsRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SecurityReportsRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SecurityReportsRoot from the service
     *
     * @return the SecurityReportsRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SecurityReportsRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SecurityReportsRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SecurityReportsRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SecurityReportsRoot with a source
     *
     * @param sourceSecurityReportsRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SecurityReportsRoot> patchAsync(@Nonnull final SecurityReportsRoot sourceSecurityReportsRoot) {
        return sendAsync(HttpMethod.PATCH, sourceSecurityReportsRoot);
    }

    /**
     * Patches this SecurityReportsRoot with a source
     *
     * @param sourceSecurityReportsRoot the source object with updates
     * @return the updated SecurityReportsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SecurityReportsRoot patch(@Nonnull final SecurityReportsRoot sourceSecurityReportsRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceSecurityReportsRoot);
    }

    /**
     * Creates a SecurityReportsRoot with a new object
     *
     * @param newSecurityReportsRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SecurityReportsRoot> postAsync(@Nonnull final SecurityReportsRoot newSecurityReportsRoot) {
        return sendAsync(HttpMethod.POST, newSecurityReportsRoot);
    }

    /**
     * Creates a SecurityReportsRoot with a new object
     *
     * @param newSecurityReportsRoot the new object to create
     * @return the created SecurityReportsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SecurityReportsRoot post(@Nonnull final SecurityReportsRoot newSecurityReportsRoot) throws ClientException {
        return send(HttpMethod.POST, newSecurityReportsRoot);
    }

    /**
     * Creates a SecurityReportsRoot with a new object
     *
     * @param newSecurityReportsRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SecurityReportsRoot> putAsync(@Nonnull final SecurityReportsRoot newSecurityReportsRoot) {
        return sendAsync(HttpMethod.PUT, newSecurityReportsRoot);
    }

    /**
     * Creates a SecurityReportsRoot with a new object
     *
     * @param newSecurityReportsRoot the object to create/update
     * @return the created SecurityReportsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SecurityReportsRoot put(@Nonnull final SecurityReportsRoot newSecurityReportsRoot) throws ClientException {
        return send(HttpMethod.PUT, newSecurityReportsRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SecurityReportsRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SecurityReportsRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

