// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TeamworkTag;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Tag Request.
 */
public class TeamworkTagRequest extends BaseRequest<TeamworkTag> {
	
    /**
     * The request for the TeamworkTag
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamworkTagRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamworkTag.class);
    }

    /**
     * Gets the TeamworkTag from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTag> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TeamworkTag from the service
     *
     * @return the TeamworkTag from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTag get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTag> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TeamworkTag delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamworkTag with a source
     *
     * @param sourceTeamworkTag the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTag> patchAsync(@Nonnull final TeamworkTag sourceTeamworkTag) {
        return sendAsync(HttpMethod.PATCH, sourceTeamworkTag);
    }

    /**
     * Patches this TeamworkTag with a source
     *
     * @param sourceTeamworkTag the source object with updates
     * @return the updated TeamworkTag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTag patch(@Nonnull final TeamworkTag sourceTeamworkTag) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamworkTag);
    }

    /**
     * Creates a TeamworkTag with a new object
     *
     * @param newTeamworkTag the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTag> postAsync(@Nonnull final TeamworkTag newTeamworkTag) {
        return sendAsync(HttpMethod.POST, newTeamworkTag);
    }

    /**
     * Creates a TeamworkTag with a new object
     *
     * @param newTeamworkTag the new object to create
     * @return the created TeamworkTag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTag post(@Nonnull final TeamworkTag newTeamworkTag) throws ClientException {
        return send(HttpMethod.POST, newTeamworkTag);
    }

    /**
     * Creates a TeamworkTag with a new object
     *
     * @param newTeamworkTag the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkTag> putAsync(@Nonnull final TeamworkTag newTeamworkTag) {
        return sendAsync(HttpMethod.PUT, newTeamworkTag);
    }

    /**
     * Creates a TeamworkTag with a new object
     *
     * @param newTeamworkTag the object to create/update
     * @return the created TeamworkTag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkTag put(@Nonnull final TeamworkTag newTeamworkTag) throws ClientException {
        return send(HttpMethod.PUT, newTeamworkTag);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkTagRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkTagRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

