// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TenantRelationship;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tenant Relationship Request.
 */
public class TenantRelationshipRequest extends BaseRequest<TenantRelationship> {
	
    /**
     * The request for the TenantRelationship
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TenantRelationshipRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TenantRelationship.class);
    }

    /**
     * Gets the TenantRelationship from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantRelationship> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TenantRelationship from the service
     *
     * @return the TenantRelationship from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantRelationship get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantRelationship> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TenantRelationship delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TenantRelationship with a source
     *
     * @param sourceTenantRelationship the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantRelationship> patchAsync(@Nonnull final TenantRelationship sourceTenantRelationship) {
        return sendAsync(HttpMethod.PATCH, sourceTenantRelationship);
    }

    /**
     * Patches this TenantRelationship with a source
     *
     * @param sourceTenantRelationship the source object with updates
     * @return the updated TenantRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantRelationship patch(@Nonnull final TenantRelationship sourceTenantRelationship) throws ClientException {
        return send(HttpMethod.PATCH, sourceTenantRelationship);
    }

    /**
     * Creates a TenantRelationship with a new object
     *
     * @param newTenantRelationship the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantRelationship> postAsync(@Nonnull final TenantRelationship newTenantRelationship) {
        return sendAsync(HttpMethod.POST, newTenantRelationship);
    }

    /**
     * Creates a TenantRelationship with a new object
     *
     * @param newTenantRelationship the new object to create
     * @return the created TenantRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantRelationship post(@Nonnull final TenantRelationship newTenantRelationship) throws ClientException {
        return send(HttpMethod.POST, newTenantRelationship);
    }

    /**
     * Creates a TenantRelationship with a new object
     *
     * @param newTenantRelationship the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TenantRelationship> putAsync(@Nonnull final TenantRelationship newTenantRelationship) {
        return sendAsync(HttpMethod.PUT, newTenantRelationship);
    }

    /**
     * Creates a TenantRelationship with a new object
     *
     * @param newTenantRelationship the object to create/update
     * @return the created TenantRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TenantRelationship put(@Nonnull final TenantRelationship newTenantRelationship) throws ClientException {
        return send(HttpMethod.PUT, newTenantRelationship);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TenantRelationshipRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TenantRelationshipRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

