// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Alert;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Alert Request.
 */
public class AlertRequest extends BaseRequest<Alert> {
	
    /**
     * The request for the Alert
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AlertRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Alert.class);
    }

    /**
     * Gets the Alert from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Alert> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Alert from the service
     *
     * @return the Alert from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Alert get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Alert> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Alert delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Alert with a source
     *
     * @param sourceAlert the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Alert> patchAsync(@Nonnull final Alert sourceAlert) {
        return sendAsync(HttpMethod.PATCH, sourceAlert);
    }

    /**
     * Patches this Alert with a source
     *
     * @param sourceAlert the source object with updates
     * @return the updated Alert
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Alert patch(@Nonnull final Alert sourceAlert) throws ClientException {
        return send(HttpMethod.PATCH, sourceAlert);
    }

    /**
     * Creates a Alert with a new object
     *
     * @param newAlert the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Alert> postAsync(@Nonnull final Alert newAlert) {
        return sendAsync(HttpMethod.POST, newAlert);
    }

    /**
     * Creates a Alert with a new object
     *
     * @param newAlert the new object to create
     * @return the created Alert
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Alert post(@Nonnull final Alert newAlert) throws ClientException {
        return send(HttpMethod.POST, newAlert);
    }

    /**
     * Creates a Alert with a new object
     *
     * @param newAlert the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Alert> putAsync(@Nonnull final Alert newAlert) {
        return sendAsync(HttpMethod.PUT, newAlert);
    }

    /**
     * Creates a Alert with a new object
     *
     * @param newAlert the object to create/update
     * @return the created Alert
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Alert put(@Nonnull final Alert newAlert) throws ClientException {
        return send(HttpMethod.PUT, newAlert);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AlertRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AlertRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

