/*
 * Decompiled with CFR 0.152.
 */
package denominator;

import denominator.common.Preconditions;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceTypeToValue {
    private static Map<String, Integer> lookup = new LinkedHashMap<String, Integer>();
    private static Map<Integer, String> inverse = new LinkedHashMap<Integer, String>();

    public static Integer lookup(String type) throws IllegalArgumentException {
        Preconditions.checkNotNull(type, "resource type was null", new Object[0]);
        Preconditions.checkArgument(lookup.containsKey(type), "%s do not include %s; types: %s", ResourceTypes.class.getSimpleName(), type, EnumSet.allOf(ResourceTypes.class));
        return lookup.get(type);
    }

    public static String lookup(Integer type) throws IllegalArgumentException {
        Preconditions.checkNotNull(type, "resource type was null", new Object[0]);
        Preconditions.checkArgument(inverse.containsKey(type), "%s do not include %s; types: %s", ResourceTypes.class.getSimpleName(), type, EnumSet.allOf(ResourceTypes.class));
        return inverse.get(type);
    }

    static {
        for (ResourceTypes r : EnumSet.allOf(ResourceTypes.class)) {
            lookup.put(r.name(), r.value);
            inverse.put(r.value, r.name());
        }
    }

    static enum ResourceTypes {
        A(1),
        NS(2),
        CNAME(5),
        SOA(6),
        PTR(12),
        MX(15),
        TXT(16),
        AAAA(28),
        LOC(29),
        NAPTR(35),
        CERT(37),
        DS(43),
        SSHFP(44),
        TLSA(52),
        SPF(99),
        SRV(33);

        private final int value;

        private ResourceTypes(int value) {
            this.value = value;
        }
    }
}

