/*
 * Decompiled with CFR 0.152.
 */
package denominator.model;

import denominator.model.ResourceRecordSet;
import denominator.model.profile.Geo;
import denominator.model.profile.Weighted;
import java.util.List;
import java.util.Map;

abstract class AbstractRecordSetBuilder<E, D extends Map<String, Object>, B extends AbstractRecordSetBuilder<E, D, B>> {
    private String name;
    private String type;
    private String qualifier;
    private Integer ttl;
    private Geo geo;
    private Weighted weighted;

    AbstractRecordSetBuilder() {
    }

    public B name(String name) {
        this.name = name;
        return (B)this;
    }

    public B type(String type) {
        this.type = type;
        return (B)this;
    }

    public B qualifier(String qualifier) {
        this.qualifier = qualifier;
        return (B)this;
    }

    public B ttl(Integer ttl) {
        this.ttl = ttl;
        return (B)this;
    }

    public B geo(Geo geo) {
        this.geo = geo;
        return (B)this;
    }

    public B weighted(Weighted weighted) {
        this.weighted = weighted;
        return (B)this;
    }

    public ResourceRecordSet<D> build() {
        return new ResourceRecordSet<D>(this.name, this.type, this.qualifier, this.ttl, this.records(), this.geo, this.weighted);
    }

    protected abstract List<D> records();
}

