/*
 * Decompiled with CFR 0.152.
 */
package denominator.model;

import denominator.common.Preconditions;
import denominator.common.Util;
import denominator.model.AbstractRecordSetBuilder;
import denominator.model.profile.Geo;
import denominator.model.profile.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResourceRecordSet<D extends Map<String, Object>> {
    private final String name;
    private final String type;
    private final String qualifier;
    private final Integer ttl;
    private final List<D> records;
    private final Geo geo;
    private final Weighted weighted;

    ResourceRecordSet(String name, String type, String qualifier, Integer ttl, List<D> records, Geo geo, Weighted weighted) {
        Preconditions.checkArgument(Preconditions.checkNotNull(name, "name", new Object[0]).length() <= 255, "Name must be <= 255 characters", new Object[0]);
        this.name = name;
        this.type = Preconditions.checkNotNull(type, "type of %s", name);
        this.qualifier = qualifier;
        if (ttl != null) {
            boolean rfc2181 = ttl >= 0 && ttl.longValue() <= Integer.MAX_VALUE;
            Preconditions.checkArgument(rfc2181, "Invalid ttl value: %s, must be 0-2147483647", ttl);
        }
        this.ttl = ttl;
        this.records = Collections.unmodifiableList(records != null ? records : Collections.emptyList());
        this.geo = geo;
        this.weighted = weighted;
    }

    public static <D extends Map<String, Object>> Builder<D> builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public Integer ttl() {
        return this.ttl;
    }

    public Geo geo() {
        return this.geo;
    }

    public Weighted weighted() {
        return this.weighted;
    }

    public List<D> records() {
        return this.records;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceRecordSet) {
            ResourceRecordSet other = (ResourceRecordSet)obj;
            return Util.equal(this.name(), other.name()) && Util.equal(this.type(), other.type()) && Util.equal(this.qualifier(), other.qualifier()) && Util.equal(this.ttl(), other.ttl()) && Util.equal(this.records(), other.records()) && Util.equal(this.geo(), other.geo()) && Util.equal(this.weighted(), other.weighted());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name().hashCode();
        result = 31 * result + this.type().hashCode();
        result = 31 * result + (this.qualifier() != null ? this.qualifier().hashCode() : 0);
        result = 31 * result + (this.ttl() != null ? this.ttl().hashCode() : 0);
        result = 31 * result + this.records().hashCode();
        result = 31 * result + (this.geo() != null ? this.geo().hashCode() : 0);
        result = 31 * result + (this.weighted() != null ? this.weighted().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceRecordSet [");
        builder.append("name=").append(this.name());
        builder.append(", ").append("type=").append(this.type());
        if (this.qualifier() != null) {
            builder.append(", ").append("qualifier=").append(this.qualifier());
        }
        if (this.ttl() != null) {
            builder.append(", ").append("ttl=").append(this.ttl());
        }
        builder.append(", ").append("records=").append(this.records());
        if (this.geo() != null) {
            builder.append(", ").append("geo=").append(this.geo());
        }
        if (this.weighted() != null) {
            builder.append(", ").append("weighted=").append(this.weighted());
        }
        builder.append("]");
        return builder.toString();
    }

    public static class Builder<D extends Map<String, Object>>
    extends AbstractRecordSetBuilder<D, D, Builder<D>> {
        private List<D> records = new ArrayList<D>();

        public Builder<D> add(D record) {
            this.records.add(Preconditions.checkNotNull(record, "record", new Object[0]));
            return this;
        }

        public Builder<D> addAll(D ... records) {
            this.records.addAll(Arrays.asList(Preconditions.checkNotNull(records, "records", new Object[0])));
            return this;
        }

        public <R extends D> Builder<D> addAll(Collection<R> records) {
            this.records.addAll(Preconditions.checkNotNull(records, "records", new Object[0]));
            return this;
        }

        @Override
        protected List<D> records() {
            return this.records;
        }
    }
}

