/*
 * Decompiled with CFR 0.152.
 */
package denominator.model;

import denominator.common.Filter;
import denominator.common.Preconditions;
import denominator.model.ResourceRecordSet;
import denominator.model.StringRecordBuilder;
import denominator.model.rdata.AAAAData;
import denominator.model.rdata.AData;
import denominator.model.rdata.CERTData;
import denominator.model.rdata.CNAMEData;
import denominator.model.rdata.MXData;
import denominator.model.rdata.NAPTRData;
import denominator.model.rdata.NSData;
import denominator.model.rdata.PTRData;
import denominator.model.rdata.SOAData;
import denominator.model.rdata.SPFData;
import denominator.model.rdata.SRVData;
import denominator.model.rdata.SSHFPData;
import denominator.model.rdata.TXTData;
import java.util.Collection;
import java.util.Map;

public class ResourceRecordSets {
    private ResourceRecordSets() {
    }

    public static Filter<ResourceRecordSet<?>> notNull() {
        return new Filter<ResourceRecordSet<?>>(){

            @Override
            public boolean apply(ResourceRecordSet<?> in) {
                return in != null;
            }
        };
    }

    public static Filter<ResourceRecordSet<?>> nameEqualTo(final String name) {
        Preconditions.checkNotNull(name, "name", new Object[0]);
        return new Filter<ResourceRecordSet<?>>(){

            @Override
            public boolean apply(ResourceRecordSet<?> in) {
                return in != null && name.equals(in.name());
            }

            public String toString() {
                return "nameEqualTo(" + name + ")";
            }
        };
    }

    public static Filter<ResourceRecordSet<?>> nameAndTypeEqualTo(final String name, final String type) {
        Preconditions.checkNotNull(name, "name", new Object[0]);
        Preconditions.checkNotNull(type, "type", new Object[0]);
        return new Filter<ResourceRecordSet<?>>(){

            @Override
            public boolean apply(ResourceRecordSet<?> in) {
                return in != null && name.equals(in.name()) && type.equals(in.type());
            }

            public String toString() {
                return "nameAndTypeEqualTo(" + name + "," + type + ")";
            }
        };
    }

    public static Filter<ResourceRecordSet<?>> nameTypeAndQualifierEqualTo(final String name, final String type, final String qualifier) {
        Preconditions.checkNotNull(name, "name", new Object[0]);
        Preconditions.checkNotNull(type, "type", new Object[0]);
        Preconditions.checkNotNull(qualifier, "qualifier", new Object[0]);
        return new Filter<ResourceRecordSet<?>>(){

            @Override
            public boolean apply(ResourceRecordSet<?> in) {
                return in != null && name.equals(in.name()) && type.equals(in.type()) && qualifier.equals(in.qualifier());
            }

            public String toString() {
                return "nameTypeAndQualifierEqualTo(" + name + "," + type + "," + qualifier + ")";
            }
        };
    }

    public static Filter<ResourceRecordSet<?>> containsRecord(Map<String, ?> record) {
        return new ContainsRecord(record);
    }

    public static Filter<ResourceRecordSet<?>> alwaysVisible() {
        return new Filter<ResourceRecordSet<?>>(){

            @Override
            public boolean apply(ResourceRecordSet<?> in) {
                return in != null && in.qualifier() == null;
            }

            public String toString() {
                return "alwaysVisible()";
            }
        };
    }

    public static ResourceRecordSet<SOAData> soa(ResourceRecordSet<?> soa, String email, int ttl) {
        SOAData soaData = (SOAData)soa.records().get(0);
        soaData = soaData.toBuilder().serial(soaData.serial() + 1).rname(email).build();
        return ((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)ResourceRecordSet.builder().name(soa.name())).type("SOA")).ttl(ttl)).add(soaData).build();
    }

    public static ResourceRecordSet<AData> a(String name, String address) {
        return ((StringRecordBuilder)new ABuilder().name(name)).add(address).build();
    }

    public static ResourceRecordSet<AData> a(String name, int ttl, String address) {
        return ((StringRecordBuilder)((StringRecordBuilder)new ABuilder().name(name)).ttl(ttl)).add(address).build();
    }

    public static ResourceRecordSet<AData> a(String name, Collection<String> addresses) {
        return ((StringRecordBuilder)new ABuilder().name(name)).addAll(addresses).build();
    }

    public static ResourceRecordSet<AData> a(String name, int ttl, Collection<String> addresses) {
        return ((StringRecordBuilder)((StringRecordBuilder)new ABuilder().name(name)).ttl(ttl)).addAll(addresses).build();
    }

    public static ResourceRecordSet<AAAAData> aaaa(String name, String address) {
        return ((StringRecordBuilder)new AAAABuilder().name(name)).add(address).build();
    }

    public static ResourceRecordSet<AAAAData> aaaa(String name, int ttl, String address) {
        return ((StringRecordBuilder)((StringRecordBuilder)new AAAABuilder().name(name)).ttl(ttl)).add(address).build();
    }

    public static ResourceRecordSet<AAAAData> aaaa(String name, Collection<String> addresses) {
        return ((StringRecordBuilder)new AAAABuilder().name(name)).addAll(addresses).build();
    }

    public static ResourceRecordSet<AAAAData> aaaa(String name, int ttl, Collection<String> addresses) {
        return ((StringRecordBuilder)((StringRecordBuilder)new AAAABuilder().name(name)).ttl(ttl)).addAll(addresses).build();
    }

    public static ResourceRecordSet<CNAMEData> cname(String name, String cname) {
        return ((StringRecordBuilder)new CNAMEBuilder().name(name)).add(cname).build();
    }

    public static ResourceRecordSet<CNAMEData> cname(String name, int ttl, String cname) {
        return ((StringRecordBuilder)((StringRecordBuilder)new CNAMEBuilder().name(name)).ttl(ttl)).add(cname).build();
    }

    public static ResourceRecordSet<CNAMEData> cname(String name, Collection<String> cnames) {
        return ((StringRecordBuilder)new CNAMEBuilder().name(name)).addAll(cnames).build();
    }

    public static ResourceRecordSet<CNAMEData> cname(String name, int ttl, Collection<String> cnames) {
        return ((StringRecordBuilder)((StringRecordBuilder)new CNAMEBuilder().name(name)).ttl(ttl)).addAll(cnames).build();
    }

    public static ResourceRecordSet<NSData> ns(String name, String nsdname) {
        return ((StringRecordBuilder)new NSBuilder().name(name)).add(nsdname).build();
    }

    public static ResourceRecordSet<NSData> ns(String name, int ttl, String nsdname) {
        return ((StringRecordBuilder)((StringRecordBuilder)new NSBuilder().name(name)).ttl(ttl)).add(nsdname).build();
    }

    public static ResourceRecordSet<NSData> ns(String name, Collection<String> nsdnames) {
        return ((StringRecordBuilder)new NSBuilder().name(name)).addAll(nsdnames).build();
    }

    public static ResourceRecordSet<NSData> ns(String name, int ttl, Collection<String> nsdnames) {
        return ((StringRecordBuilder)((StringRecordBuilder)new NSBuilder().name(name)).ttl(ttl)).addAll(nsdnames).build();
    }

    public static ResourceRecordSet<PTRData> ptr(String name, String ptrdname) {
        return ((StringRecordBuilder)new PTRBuilder().name(name)).add(ptrdname).build();
    }

    public static ResourceRecordSet<PTRData> ptr(String name, int ttl, String ptrdname) {
        return ((StringRecordBuilder)((StringRecordBuilder)new PTRBuilder().name(name)).ttl(ttl)).add(ptrdname).build();
    }

    public static ResourceRecordSet<PTRData> ptr(String name, Collection<String> ptrdnames) {
        return ((StringRecordBuilder)new PTRBuilder().name(name)).addAll(ptrdnames).build();
    }

    public static ResourceRecordSet<PTRData> ptr(String name, int ttl, Collection<String> ptrdnames) {
        return ((StringRecordBuilder)((StringRecordBuilder)new PTRBuilder().name(name)).ttl(ttl)).addAll(ptrdnames).build();
    }

    public static ResourceRecordSet<SPFData> spf(String name, String spfdata) {
        return ((StringRecordBuilder)new SPFBuilder().name(name)).add(spfdata).build();
    }

    public static ResourceRecordSet<SPFData> spf(String name, int ttl, String spfdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new SPFBuilder().name(name)).ttl(ttl)).add(spfdata).build();
    }

    public static ResourceRecordSet<SPFData> spf(String name, Collection<String> spfdata) {
        return ((StringRecordBuilder)new SPFBuilder().name(name)).addAll(spfdata).build();
    }

    public static ResourceRecordSet<SPFData> spf(String name, int ttl, Collection<String> spfdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new SPFBuilder().name(name)).ttl(ttl)).addAll(spfdata).build();
    }

    public static ResourceRecordSet<TXTData> txt(String name, String txtdata) {
        return ((StringRecordBuilder)new TXTBuilder().name(name)).add(txtdata).build();
    }

    public static ResourceRecordSet<TXTData> txt(String name, int ttl, String txtdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new TXTBuilder().name(name)).ttl(ttl)).add(txtdata).build();
    }

    public static ResourceRecordSet<TXTData> txt(String name, Collection<String> txtdata) {
        return ((StringRecordBuilder)new TXTBuilder().name(name)).addAll(txtdata).build();
    }

    public static ResourceRecordSet<TXTData> txt(String name, int ttl, Collection<String> txtdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new TXTBuilder().name(name)).ttl(ttl)).addAll(txtdata).build();
    }

    public static ResourceRecordSet<MXData> mx(String name, String mxdata) {
        return ((StringRecordBuilder)new MXBuilder().name(name)).add(mxdata).build();
    }

    public static ResourceRecordSet<MXData> mx(String name, int ttl, String mxdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new MXBuilder().name(name)).ttl(ttl)).add(mxdata).build();
    }

    public static ResourceRecordSet<MXData> mx(String name, Collection<String> mxdata) {
        return ((StringRecordBuilder)new MXBuilder().name(name)).addAll(mxdata).build();
    }

    public static ResourceRecordSet<MXData> mx(String name, int ttl, Collection<String> mxdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new MXBuilder().name(name)).ttl(ttl)).addAll(mxdata).build();
    }

    public static ResourceRecordSet<SRVData> srv(String name, String srvdata) {
        return ((StringRecordBuilder)new SRVBuilder().name(name)).add(srvdata).build();
    }

    public static ResourceRecordSet<SRVData> srv(String name, int ttl, String srvdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new SRVBuilder().name(name)).ttl(ttl)).add(srvdata).build();
    }

    public static ResourceRecordSet<SRVData> srv(String name, Collection<String> srvdata) {
        return ((StringRecordBuilder)new SRVBuilder().name(name)).addAll(srvdata).build();
    }

    public static ResourceRecordSet<SRVData> srv(String name, int ttl, Collection<String> srvdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new SRVBuilder().name(name)).ttl(ttl)).addAll(srvdata).build();
    }

    public static ResourceRecordSet<CERTData> cert(String name, String certdata) {
        return ((StringRecordBuilder)new CERTBuilder().name(name)).add(certdata).build();
    }

    public static ResourceRecordSet<CERTData> cert(String name, int ttl, String certdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new CERTBuilder().name(name)).ttl(ttl)).add(certdata).build();
    }

    public static ResourceRecordSet<CERTData> cert(String name, Collection<String> certdata) {
        return ((StringRecordBuilder)new CERTBuilder().name(name)).addAll(certdata).build();
    }

    public static ResourceRecordSet<CERTData> cert(String name, int ttl, Collection<String> certdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new CERTBuilder().name(name)).ttl(ttl)).addAll(certdata).build();
    }

    public static ResourceRecordSet<NAPTRData> naptr(String name, String naptrdata) {
        return ((StringRecordBuilder)new NAPTRBuilder().name(name)).add(naptrdata).build();
    }

    public static ResourceRecordSet<NAPTRData> naptr(String name, int ttl, String naptrdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new NAPTRBuilder().name(name)).ttl(ttl)).add(naptrdata).build();
    }

    public static ResourceRecordSet<NAPTRData> naptr(String name, Collection<String> naptrdata) {
        return ((StringRecordBuilder)new NAPTRBuilder().name(name)).addAll(naptrdata).build();
    }

    public static ResourceRecordSet<NAPTRData> naptr(String name, int ttl, Collection<String> naptrdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new NAPTRBuilder().name(name)).ttl(ttl)).addAll(naptrdata).build();
    }

    public static ResourceRecordSet<SSHFPData> sshfp(String name, String sshfpdata) {
        return ((StringRecordBuilder)new SSHFPBuilder().name(name)).add(sshfpdata).build();
    }

    public static ResourceRecordSet<SSHFPData> sshfp(String name, int ttl, String sshfpdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new SSHFPBuilder().name(name)).ttl(ttl)).add(sshfpdata).build();
    }

    public static ResourceRecordSet<SSHFPData> sshfp(String name, Collection<String> sshfpdata) {
        return ((StringRecordBuilder)new SSHFPBuilder().name(name)).addAll(sshfpdata).build();
    }

    public static ResourceRecordSet<SSHFPData> sshfp(String name, int ttl, Collection<String> sshfpdata) {
        return ((StringRecordBuilder)((StringRecordBuilder)new SSHFPBuilder().name(name)).ttl(ttl)).addAll(sshfpdata).build();
    }

    private static class SSHFPBuilder
    extends StringRecordBuilder<SSHFPData> {
        private SSHFPBuilder() {
            this.type("SSHFP");
        }

        @Override
        public SSHFPData apply(String input) {
            String[] parts = input.split(" ");
            Preconditions.checkArgument(parts.length == 3, "record must have exactly three parts", new Object[0]);
            return SSHFPData.builder().algorithm(Integer.parseInt(parts[0])).fptype(Integer.parseInt(parts[1])).fingerprint(parts[2]).build();
        }
    }

    private static class NAPTRBuilder
    extends StringRecordBuilder<NAPTRData> {
        private NAPTRBuilder() {
            this.type("NAPTR");
        }

        @Override
        public NAPTRData apply(String input) {
            String[] parts = input.split(" ");
            Preconditions.checkArgument(parts.length == 6, "record must have exactly six parts", new Object[0]);
            return NAPTRData.builder().order(Integer.parseInt(parts[0])).preference(Integer.parseInt(parts[1])).flags(parts[2]).services(parts[3]).regexp(parts[4]).replacement(parts[5]).build();
        }
    }

    private static class CERTBuilder
    extends StringRecordBuilder<CERTData> {
        private CERTBuilder() {
            this.type("CERT");
        }

        @Override
        public CERTData apply(String input) {
            String[] parts = input.split(" ");
            Preconditions.checkArgument(parts.length == 4, "record must have exactly four parts", new Object[0]);
            return CERTData.builder().format(Integer.parseInt(parts[0])).tag(Integer.parseInt(parts[1])).algorithm(Integer.parseInt(parts[2])).certificate(parts[3]).build();
        }
    }

    private static class SRVBuilder
    extends StringRecordBuilder<SRVData> {
        private SRVBuilder() {
            this.type("SRV");
        }

        @Override
        public SRVData apply(String input) {
            String[] parts = input.split(" ");
            Preconditions.checkArgument(parts.length == 4, "record must have exactly four parts", new Object[0]);
            return SRVData.builder().priority(Integer.parseInt(parts[0])).weight(Integer.parseInt(parts[1])).port(Integer.parseInt(parts[2])).target(parts[3]).build();
        }
    }

    private static class MXBuilder
    extends StringRecordBuilder<MXData> {
        private MXBuilder() {
            this.type("MX");
        }

        @Override
        public MXData apply(String input) {
            String[] parts = input.split(" ");
            Preconditions.checkArgument(parts.length == 2, "record must have exactly two parts", new Object[0]);
            return MXData.create(Integer.parseInt(parts[0]), parts[1]);
        }
    }

    private static class TXTBuilder
    extends StringRecordBuilder<TXTData> {
        private TXTBuilder() {
            this.type("TXT");
        }

        @Override
        public TXTData apply(String input) {
            return TXTData.create(input);
        }
    }

    private static class SPFBuilder
    extends StringRecordBuilder<SPFData> {
        private SPFBuilder() {
            this.type("SPF");
        }

        @Override
        public SPFData apply(String input) {
            return SPFData.create(input);
        }
    }

    private static class PTRBuilder
    extends StringRecordBuilder<PTRData> {
        private PTRBuilder() {
            this.type("PTR");
        }

        @Override
        public PTRData apply(String input) {
            return PTRData.create(input);
        }
    }

    private static class NSBuilder
    extends StringRecordBuilder<NSData> {
        private NSBuilder() {
            this.type("NS");
        }

        @Override
        public NSData apply(String input) {
            return NSData.create(input);
        }
    }

    private static class CNAMEBuilder
    extends StringRecordBuilder<CNAMEData> {
        private CNAMEBuilder() {
            this.type("CNAME");
        }

        @Override
        public CNAMEData apply(String input) {
            return CNAMEData.create(input);
        }
    }

    private static class AAAABuilder
    extends StringRecordBuilder<AAAAData> {
        private AAAABuilder() {
            this.type("AAAA");
        }

        @Override
        public AAAAData apply(String input) {
            return AAAAData.create(input);
        }
    }

    private static class ABuilder
    extends StringRecordBuilder<AData> {
        private ABuilder() {
            this.type("A");
        }

        @Override
        public AData apply(String input) {
            return AData.create(input);
        }
    }

    private static final class ContainsRecord
    implements Filter<ResourceRecordSet<?>> {
        private final Map<String, ?> record;

        public ContainsRecord(Map<String, ?> record) {
            this.record = Preconditions.checkNotNull(record, "record", new Object[0]);
        }

        @Override
        public boolean apply(ResourceRecordSet<?> input) {
            if (input == null) {
                return false;
            }
            return input.records().contains(this.record);
        }

        public String toString() {
            return "containsRecord(" + this.record + ")";
        }
    }
}

