/*
 * Decompiled with CFR 0.152.
 */
package denominator.model;

import denominator.common.Preconditions;
import denominator.common.Util;

public class Zone {
    private final String id;
    private final String name;
    private final int ttl;
    private final String email;

    Zone(String id, String name, int ttl, String email) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "name", new Object[0]);
        this.email = Preconditions.checkNotNull(email, "email of %s", name);
        Preconditions.checkArgument(ttl >= 0, "Invalid ttl value: %s, must be 0-%s", ttl, Integer.MAX_VALUE);
        this.ttl = ttl;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public int ttl() {
        return this.ttl;
    }

    public String email() {
        return this.email;
    }

    @Deprecated
    public String idOrName() {
        return this.id() != null ? this.id() : this.name();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Zone) {
            Zone other = (Zone)obj;
            return Util.equal(this.id(), other.id()) && this.name().equals(other.name()) && this.ttl() == other.ttl() && this.email().equals(other.email());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.id() != null ? this.id().hashCode() : 0);
        result = 31 * result + this.name().hashCode();
        result = 31 * result + this.ttl();
        result = 31 * result + this.email().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Zone [");
        if (!this.name().equals(this.id())) {
            builder.append("id=").append(this.id()).append(", ");
        }
        builder.append("name=").append(this.name());
        builder.append(", ").append("ttl=").append(this.ttl());
        builder.append(", ").append("email=").append(this.email());
        builder.append("]");
        return builder.toString();
    }

    @Deprecated
    public static Zone create(String name) {
        return Zone.create(name, name);
    }

    @Deprecated
    public static Zone create(String name, String id) {
        return new Zone(id, name, 86400, "nil@" + name);
    }

    public static Zone create(String id, String name, int ttl, String email) {
        return new Zone(id, name, ttl, email);
    }
}

