/*
 * Decompiled with CFR 0.152.
 */
package denominator.model.profile;

import denominator.common.Preconditions;
import denominator.model.ResourceRecordSet;
import denominator.model.profile.Geo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class Geos {
    public static ResourceRecordSet<?> withAdditionalRegions(ResourceRecordSet<?> existing, Map<String, Collection<String>> regionsToAdd) throws IllegalArgumentException {
        Preconditions.checkArgument(!regionsToAdd.isEmpty(), "no regions specified", new Object[0]);
        Preconditions.checkArgument(existing.geo() != null, "rrset does not include geo configuration: %s", existing);
        LinkedHashMap<String, Collection<String>> regionsToApply = new LinkedHashMap<String, Collection<String>>();
        for (Map.Entry<String, Collection<String>> entry : existing.geo().regions().entrySet()) {
            regionsToApply.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Collection<String>> entry : regionsToAdd.entrySet()) {
            ArrayList<String> updates = new ArrayList<String>();
            if (regionsToApply.containsKey(entry.getKey())) {
                updates.addAll((Collection)regionsToApply.get(entry.getKey()));
            }
            updates.addAll(entry.getValue());
            regionsToApply.put(entry.getKey(), updates);
        }
        boolean noop = true;
        for (Map.Entry entry : regionsToApply.entrySet()) {
            if (!existing.geo().regions().containsKey(entry.getKey())) {
                noop = false;
                break;
            }
            Collection<String> existingTerritories = existing.geo().regions().get(entry.getKey());
            if (existingTerritories.containsAll((Collection)entry.getValue())) continue;
            noop = false;
            break;
        }
        if (noop) {
            return existing;
        }
        return ((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)((ResourceRecordSet.Builder)ResourceRecordSet.builder().name(existing.name())).type(existing.type())).qualifier(existing.qualifier())).ttl(existing.ttl())).geo(Geo.create(regionsToApply))).weighted(existing.weighted())).addAll(existing.records()).build();
    }
}

