/*
 * Decompiled with CFR 0.152.
 */
package denominator.model.rdata;

import denominator.common.Preconditions;
import denominator.model.NumbersAreUnsignedIntsLinkedHashMap;

public final class CERTData
extends NumbersAreUnsignedIntsLinkedHashMap {
    private static final long serialVersionUID = 1L;

    CERTData(int format, int tag, int algorithm, String certificate) {
        Preconditions.checkArgument(format <= 65535, "format must be 0-65535", new Object[0]);
        Preconditions.checkArgument(tag <= 65535, "tag must be 0-65535", new Object[0]);
        Preconditions.checkArgument(algorithm <= 255, "algorithm must be 0-255", new Object[0]);
        Preconditions.checkNotNull(certificate, "certificate", new Object[0]);
        this.put("format", (Object)format);
        this.put("tag", (Object)tag);
        this.put("algorithm", (Object)algorithm);
        this.put("certificate", (Object)certificate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int format() {
        return (Integer)Integer.class.cast(this.get("format"));
    }

    public int tag() {
        return (Integer)Integer.class.cast(this.get("tag"));
    }

    public int algorithm() {
        return (Integer)Integer.class.cast(this.get("algorithm"));
    }

    public String certificate() {
        return this.get("certificate").toString();
    }

    public Builder toBuilder() {
        return CERTData.builder().from(this);
    }

    public static final class Builder {
        private int format = -1;
        private int tag = -1;
        private int algorithm = -1;
        private String certificate;

        public Builder format(int format) {
            this.format = format;
            return this;
        }

        public Builder tag(int tag) {
            this.tag = tag;
            return this;
        }

        public Builder algorithm(int algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public CERTData build() {
            return new CERTData(this.format, this.tag, this.algorithm, this.certificate);
        }

        public Builder from(CERTData in) {
            return this.format(in.format()).tag(in.tag()).algorithm(in.algorithm()).certificate(in.certificate());
        }
    }
}

