/*
 * Decompiled with CFR 0.152.
 */
package denominator.model.rdata;

import denominator.common.Preconditions;
import denominator.model.NumbersAreUnsignedIntsLinkedHashMap;

public final class NAPTRData
extends NumbersAreUnsignedIntsLinkedHashMap {
    private static final long serialVersionUID = 1L;

    NAPTRData(int order, int preference, String flags, String services, String regexp, String replacement) {
        Preconditions.checkArgument(order <= 65535, "order must be 0-65535", new Object[0]);
        Preconditions.checkArgument(preference <= 65535, "preference must be 0-65535", new Object[0]);
        Preconditions.checkNotNull(flags, "flags", new Object[0]);
        Preconditions.checkNotNull(services, "services", new Object[0]);
        Preconditions.checkNotNull(regexp, "regexp", new Object[0]);
        Preconditions.checkNotNull(replacement, "replacement", new Object[0]);
        this.put("order", (Object)order);
        this.put("preference", (Object)preference);
        this.put("flags", (Object)flags);
        this.put("services", (Object)services);
        this.put("regexp", (Object)regexp);
        this.put("replacement", (Object)replacement);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int order() {
        return (Integer)Integer.class.cast(this.get("order"));
    }

    public int preference() {
        return (Integer)Integer.class.cast(this.get("preference"));
    }

    public String flags() {
        return this.get("flags").toString();
    }

    public String services() {
        return this.get("services").toString();
    }

    public String regexp() {
        return this.get("regexp").toString();
    }

    public String replacement() {
        return this.get("replacement").toString();
    }

    public Builder toBuilder() {
        return NAPTRData.builder().from(this);
    }

    public static final class Builder {
        private int order = -1;
        private int preference = -1;
        private String flags;
        private String services;
        private String regexp;
        private String replacement;

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder preference(int preference) {
            this.preference = preference;
            return this;
        }

        public Builder flags(String flags) {
            this.flags = flags;
            return this;
        }

        public Builder services(String services) {
            this.services = services;
            return this;
        }

        public Builder regexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        public Builder replacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public NAPTRData build() {
            return new NAPTRData(this.order, this.preference, this.flags, this.services, this.regexp, this.replacement);
        }

        public Builder from(NAPTRData in) {
            return this.order(in.order()).preference(in.preference()).flags(in.flags()).services(in.services()).regexp(in.regexp()).replacement(in.replacement());
        }
    }
}

