/*
 * Decompiled with CFR 0.152.
 */
package denominator.model.rdata;

import denominator.common.Preconditions;
import denominator.model.NumbersAreUnsignedIntsLinkedHashMap;

public final class SOAData
extends NumbersAreUnsignedIntsLinkedHashMap {
    private static final long serialVersionUID = 1L;

    SOAData(String mname, String rname, int serial, int refresh, int retry, int expire, int minimum) {
        Preconditions.checkNotNull(mname, "mname", new Object[0]);
        Preconditions.checkNotNull(rname, "rname of %s", mname);
        Preconditions.checkArgument(serial >= 0, "serial of %s must be unsigned", mname);
        Preconditions.checkArgument(refresh >= 0, "refresh of %s must be unsigned", mname);
        Preconditions.checkArgument(retry >= 0, "retry of %s must be unsigned", mname);
        Preconditions.checkArgument(expire >= 0, "expire of %s must be unsigned", mname);
        Preconditions.checkArgument(minimum >= 0, "minimum of %s must be unsigned", mname);
        this.put("mname", (Object)mname);
        this.put("rname", (Object)rname);
        this.put("serial", (Object)serial);
        this.put("refresh", (Object)refresh);
        this.put("retry", (Object)retry);
        this.put("expire", (Object)expire);
        this.put("minimum", (Object)minimum);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String mname() {
        return this.get("mname").toString();
    }

    public String rname() {
        return this.get("rname").toString();
    }

    public int serial() {
        return (Integer)Integer.class.cast(this.get("serial"));
    }

    public int refresh() {
        return (Integer)Integer.class.cast(this.get("refresh"));
    }

    public int retry() {
        return (Integer)Integer.class.cast(this.get("retry"));
    }

    public int expire() {
        return (Integer)Integer.class.cast(this.get("expire"));
    }

    public int minimum() {
        return (Integer)Integer.class.cast(this.get("minimum"));
    }

    public Builder toBuilder() {
        return SOAData.builder().from(this);
    }

    public static final class Builder {
        private String mname;
        private String rname;
        private int serial = -1;
        private int refresh = -1;
        private int retry = -1;
        private int expire = -1;
        private int minimum = -1;

        public Builder mname(String mname) {
            this.mname = mname;
            return this;
        }

        public Builder rname(String rname) {
            this.rname = rname;
            return this;
        }

        public Builder serial(int serial) {
            this.serial = serial;
            return this;
        }

        public Builder refresh(int refresh) {
            this.refresh = refresh;
            return this;
        }

        public Builder retry(int retry) {
            this.retry = retry;
            return this;
        }

        public Builder expire(int expire) {
            this.expire = expire;
            return this;
        }

        public Builder minimum(int minimum) {
            this.minimum = minimum;
            return this;
        }

        public SOAData build() {
            return new SOAData(this.mname, this.rname, this.serial, this.refresh, this.retry, this.expire, this.minimum);
        }

        public Builder from(SOAData in) {
            return this.mname(in.mname()).rname(in.rname()).serial(in.serial()).refresh(in.refresh()).retry(in.retry()).expire(in.expire()).minimum(in.minimum());
        }
    }
}

