/*
 * Decompiled with CFR 0.152.
 */
package denominator.model.rdata;

import denominator.common.Preconditions;
import denominator.model.NumbersAreUnsignedIntsLinkedHashMap;

public final class SRVData
extends NumbersAreUnsignedIntsLinkedHashMap {
    private static final long serialVersionUID = 1L;

    SRVData(int priority, int weight, int port, String target) {
        Preconditions.checkArgument(priority <= 65535, "priority must be 0-65535", new Object[0]);
        Preconditions.checkArgument(weight <= 65535, "weight must be 0-65535", new Object[0]);
        Preconditions.checkArgument(port <= 65535, "port must be 0-65535", new Object[0]);
        Preconditions.checkNotNull(target, "target", new Object[0]);
        this.put("priority", (Object)priority);
        this.put("weight", (Object)weight);
        this.put("port", (Object)port);
        this.put("target", (Object)target);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int priority() {
        return (Integer)Integer.class.cast(this.get("priority"));
    }

    public int weight() {
        return (Integer)Integer.class.cast(this.get("weight"));
    }

    public int port() {
        return (Integer)Integer.class.cast(this.get("port"));
    }

    public String target() {
        return this.get("target").toString();
    }

    public Builder toBuilder() {
        return SRVData.builder().from(this);
    }

    public static final class Builder {
        private int priority = -1;
        private int weight = -1;
        private int port = -1;
        private String target;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public SRVData build() {
            return new SRVData(this.priority, this.weight, this.port, this.target);
        }

        public Builder from(SRVData in) {
            return this.priority(in.priority()).weight(in.weight()).port(in.port()).target(in.target());
        }
    }
}

