/*
 * Decompiled with CFR 0.152.
 */
package denominator.model.rdata;

import denominator.common.Preconditions;
import denominator.model.NumbersAreUnsignedIntsLinkedHashMap;

public final class SSHFPData
extends NumbersAreUnsignedIntsLinkedHashMap {
    private static final long serialVersionUID = 1L;

    SSHFPData(int algorithm, int fptype, String fingerprint) {
        Preconditions.checkArgument(algorithm >= 0, "algorithm of %s must be unsigned", fingerprint);
        Preconditions.checkArgument(fptype >= 0, "fptype of %s must be unsigned", fingerprint);
        Preconditions.checkNotNull(fingerprint, "fingerprint", new Object[0]);
        this.put("algorithm", (Object)algorithm);
        this.put("fptype", (Object)fptype);
        this.put("fingerprint", (Object)fingerprint);
    }

    public static SSHFPData createDSA(String fingerprint) {
        return SSHFPData.builder().algorithm(2).fptype(1).fingerprint(fingerprint).build();
    }

    public static SSHFPData createRSA(String fingerprint) {
        return SSHFPData.builder().algorithm(1).fptype(1).fingerprint(fingerprint).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int algorithm() {
        return (Integer)Integer.class.cast(this.get("algorithm"));
    }

    public int fptype() {
        return (Integer)Integer.class.cast(this.get("fptype"));
    }

    public String fingerprint() {
        return this.get("fingerprint").toString();
    }

    public static final class Builder {
        private int algorithm;
        private int fptype;
        private String fingerprint;

        public Builder algorithm(int algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder fptype(int fptype) {
            this.fptype = fptype;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public SSHFPData build() {
            return new SSHFPData(this.algorithm, this.fptype, this.fingerprint);
        }
    }
}

