/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedSupervisorTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(TimedSupervisorTask.class);
    private static final String PREFIX = "TimedSupervisorTask_";
    private final Counter timeoutCounter;
    private final Counter rejectedCounter;
    private final Counter throwableCounter;
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor executor;
    private final long timeoutMillis;
    private final Runnable task;
    private final AtomicLong delay;
    private final long maxDelay;

    public TimedSupervisorTask(String name, ScheduledExecutorService scheduler, ThreadPoolExecutor executor, int timeout, TimeUnit timeUnit, int expBackOffBound, Runnable task) {
        this.scheduler = scheduler;
        this.executor = executor;
        this.timeoutMillis = timeUnit.toMillis(timeout);
        this.task = task;
        this.delay = new AtomicLong(this.timeoutMillis);
        this.maxDelay = this.timeoutMillis * (long)expBackOffBound;
        this.timeoutCounter = Monitors.newCounter((String)("TimedSupervisorTask__" + name + "_timeouts"));
        this.rejectedCounter = Monitors.newCounter((String)("TimedSupervisorTask__" + name + "_rejectedExecutions"));
        this.throwableCounter = Monitors.newCounter((String)("TimedSupervisorTask__" + name + "_throwables"));
        Monitors.registerObject((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Future<?> future = null;
        try {
            future = this.executor.submit(this.task);
            future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            this.delay.set(this.timeoutMillis);
        }
        catch (TimeoutException e) {
            logger.error("task supervisor timed out", (Throwable)e);
            this.timeoutCounter.increment();
            long currentDelay = this.delay.get();
            long newDelay = Math.min(this.maxDelay, currentDelay * 2L);
            this.delay.compareAndSet(currentDelay, newDelay);
        }
        catch (RejectedExecutionException e) {
            logger.error("task supervisor rejected the task", (Throwable)e);
            this.rejectedCounter.increment();
        }
        catch (Throwable e) {
            logger.error("task supervisor threw an exception", e);
            this.throwableCounter.increment();
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            this.scheduler.schedule(this, this.delay.get(), TimeUnit.MILLISECONDS);
        }
    }
}

