/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt;

import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JWTClaimsSet
implements ReadOnlyJWTClaimsSet {
    private static final String ISSUER_CLAIM = "iss";
    private static final String SUBJECT_CLAIM = "sub";
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String EXPIRATION_TIME_CLAIM = "exp";
    private static final String NOT_BEFORE_CLAIM = "nbf";
    private static final String ISSUED_AT_CLAIM = "iat";
    private static final String JWT_ID_CLAIM = "jti";
    private static final Set<String> REGISTERED_CLAIM_NAMES;
    private String iss = null;
    private String sub = null;
    private List<String> aud = null;
    private Date exp = null;
    private Date nbf = null;
    private Date iat = null;
    private String jti = null;
    private Map<String, Object> customClaims = new HashMap<String, Object>();

    public JWTClaimsSet() {
    }

    public JWTClaimsSet(ReadOnlyJWTClaimsSet old) {
        this.setAllClaims(old.getAllClaims());
    }

    public static Set<String> getRegisteredNames() {
        return REGISTERED_CLAIM_NAMES;
    }

    @Override
    public String getIssuer() {
        return this.iss;
    }

    public void setIssuer(String iss) {
        this.iss = iss;
    }

    @Override
    public String getSubject() {
        return this.sub;
    }

    public void setSubject(String sub) {
        this.sub = sub;
    }

    @Override
    public List<String> getAudience() {
        return this.aud;
    }

    public void setAudience(List<String> aud) {
        this.aud = aud;
    }

    public void setAudience(String aud) {
        this.aud = aud == null ? null : Arrays.asList(aud);
    }

    @Override
    public Date getExpirationTime() {
        return this.exp;
    }

    public void setExpirationTime(Date exp) {
        this.exp = exp;
    }

    @Override
    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public void setNotBeforeTime(Date nbf) {
        this.nbf = nbf;
    }

    @Override
    public Date getIssueTime() {
        return this.iat;
    }

    public void setIssueTime(Date iat) {
        this.iat = iat;
    }

    @Override
    public String getJWTID() {
        return this.jti;
    }

    public void setJWTID(String jti) {
        this.jti = jti;
    }

    @Override
    public Object getCustomClaim(String name) {
        return this.customClaims.get(name);
    }

    public void setCustomClaim(String name, Object value) {
        if (JWTClaimsSet.getRegisteredNames().contains(name)) {
            throw new IllegalArgumentException("The claim name \"" + name + "\" matches a registered name");
        }
        this.customClaims.put(name, value);
    }

    @Override
    public Map<String, Object> getCustomClaims() {
        return Collections.unmodifiableMap(this.customClaims);
    }

    public void setCustomClaims(Map<String, Object> customClaims) {
        if (customClaims == null) {
            this.customClaims.clear();
        } else {
            this.customClaims = customClaims;
        }
    }

    @Override
    public Object getClaim(String name) {
        if (ISSUER_CLAIM.equals(name)) {
            return this.getIssuer();
        }
        if (SUBJECT_CLAIM.equals(name)) {
            return this.getSubject();
        }
        if (AUDIENCE_CLAIM.equals(name)) {
            return this.getAudience();
        }
        if (EXPIRATION_TIME_CLAIM.equals(name)) {
            return this.getExpirationTime();
        }
        if (NOT_BEFORE_CLAIM.equals(name)) {
            return this.getNotBeforeTime();
        }
        if (ISSUED_AT_CLAIM.equals(name)) {
            return this.getIssueTime();
        }
        if (JWT_ID_CLAIM.equals(name)) {
            return this.getJWTID();
        }
        return this.getCustomClaim(name);
    }

    @Override
    public String getStringClaim(String name) throws ParseException {
        Object value = this.getClaim(name);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        throw new ParseException("The \"" + name + "\" claim is not a String", 0);
    }

    @Override
    public String[] getStringArrayClaim(String name) throws ParseException {
        List list;
        Object value = this.getClaim(name);
        if (value == null) {
            return null;
        }
        try {
            list = (List)this.getClaim(name);
        }
        catch (ClassCastException e) {
            throw new ParseException("The \"" + name + "\" claim is not a list / JSON array", 0);
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray[i] = (String)list.get(i);
                continue;
            }
            catch (ClassCastException e) {
                throw new ParseException("The \"" + name + "\" claim is not a list / JSON array of strings", 0);
            }
        }
        return stringArray;
    }

    @Override
    public List<String> getStringListClaim(String name) throws ParseException {
        String[] stringArray = this.getStringArrayClaim(name);
        if (stringArray == null) {
            return null;
        }
        return Arrays.asList(stringArray);
    }

    @Override
    public Boolean getBooleanClaim(String name) throws ParseException {
        Object value = this.getClaim(name);
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ParseException("The \"" + name + "\" claim is not a Boolean", 0);
    }

    @Override
    public Integer getIntegerClaim(String name) throws ParseException {
        Object value = this.getClaim(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new ParseException("The \"" + name + "\" claim is not an Integer", 0);
    }

    @Override
    public Long getLongClaim(String name) throws ParseException {
        Object value = this.getClaim(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new ParseException("The \"" + name + "\" claim is not a Number", 0);
    }

    @Override
    public Float getFloatClaim(String name) throws ParseException {
        Object value = this.getClaim(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw new ParseException("The \"" + name + "\" claim is not a Float", 0);
    }

    @Override
    public Double getDoubleClaim(String name) throws ParseException {
        Object value = this.getClaim(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new ParseException("The \"" + name + "\" claim is not a Double", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setClaim(String name, Object value) {
        if (ISSUER_CLAIM.equals(name)) {
            if (value != null && !(value instanceof String)) throw new IllegalArgumentException("Issuer claim must be a String");
            this.setIssuer((String)value);
            return;
        } else if (SUBJECT_CLAIM.equals(name)) {
            if (value != null && !(value instanceof String)) throw new IllegalArgumentException("Subject claim must be a String");
            this.setSubject((String)value);
            return;
        } else if (AUDIENCE_CLAIM.equals(name)) {
            if (value != null && !(value instanceof List)) throw new IllegalArgumentException("Audience claim must be a List<String>");
            this.setAudience((List)value);
            return;
        } else if (EXPIRATION_TIME_CLAIM.equals(name)) {
            if (value != null && !(value instanceof Date)) throw new IllegalArgumentException("Expiration claim must be a Date");
            this.setExpirationTime((Date)value);
            return;
        } else if (NOT_BEFORE_CLAIM.equals(name)) {
            if (value != null && !(value instanceof Date)) throw new IllegalArgumentException("Not-before claim must be a Date");
            this.setNotBeforeTime((Date)value);
            return;
        } else if (ISSUED_AT_CLAIM.equals(name)) {
            if (value != null && !(value instanceof Date)) throw new IllegalArgumentException("Issued-at claim must be a Date");
            this.setIssueTime((Date)value);
            return;
        } else if (JWT_ID_CLAIM.equals(name)) {
            if (value != null && !(value instanceof String)) throw new IllegalArgumentException("JWT-ID claim must be a String");
            this.setJWTID((String)value);
            return;
        } else {
            this.setCustomClaim(name, value);
        }
    }

    @Override
    public Map<String, Object> getAllClaims() {
        HashMap<String, Object> allClaims = new HashMap<String, Object>();
        allClaims.putAll(this.customClaims);
        for (String registeredClaim : REGISTERED_CLAIM_NAMES) {
            Object value = this.getClaim(registeredClaim);
            if (value == null) continue;
            allClaims.put(registeredClaim, value);
        }
        return Collections.unmodifiableMap(allClaims);
    }

    public void setAllClaims(Map<String, Object> newClaims) {
        for (String name : newClaims.keySet()) {
            this.setClaim(name, newClaims.get(name));
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject(this.customClaims);
        if (this.iss != null) {
            o.put((Object)ISSUER_CLAIM, (Object)this.iss);
        }
        if (this.sub != null) {
            o.put((Object)SUBJECT_CLAIM, (Object)this.sub);
        }
        if (this.aud != null && !this.aud.isEmpty()) {
            if (this.aud.size() == 1) {
                o.put((Object)AUDIENCE_CLAIM, (Object)this.aud.get(0));
            } else {
                JSONArray audArray = new JSONArray();
                audArray.addAll(this.aud);
                o.put((Object)AUDIENCE_CLAIM, (Object)audArray);
            }
        }
        if (this.exp != null) {
            o.put((Object)EXPIRATION_TIME_CLAIM, (Object)(this.exp.getTime() / 1000L));
        }
        if (this.nbf != null) {
            o.put((Object)NOT_BEFORE_CLAIM, (Object)(this.nbf.getTime() / 1000L));
        }
        if (this.iat != null) {
            o.put((Object)ISSUED_AT_CLAIM, (Object)(this.iat.getTime() / 1000L));
        }
        if (this.jti != null) {
            o.put((Object)JWT_ID_CLAIM, (Object)this.jti);
        }
        return o;
    }

    public static JWTClaimsSet parse(JSONObject json) throws ParseException {
        JWTClaimsSet cs = new JWTClaimsSet();
        for (String name : json.keySet()) {
            if (name.equals(ISSUER_CLAIM)) {
                cs.setIssuer(JSONObjectUtils.getString(json, ISSUER_CLAIM));
                continue;
            }
            if (name.equals(SUBJECT_CLAIM)) {
                cs.setSubject(JSONObjectUtils.getString(json, SUBJECT_CLAIM));
                continue;
            }
            if (name.equals(AUDIENCE_CLAIM)) {
                Object audValue = json.get((Object)AUDIENCE_CLAIM);
                if (audValue instanceof String) {
                    ArrayList<String> singleAud = new ArrayList<String>();
                    singleAud.add(JSONObjectUtils.getString(json, AUDIENCE_CLAIM));
                    cs.setAudience(singleAud);
                    continue;
                }
                if (!(audValue instanceof List)) continue;
                cs.setAudience(JSONObjectUtils.getStringList(json, AUDIENCE_CLAIM));
                continue;
            }
            if (name.equals(EXPIRATION_TIME_CLAIM)) {
                cs.setExpirationTime(new Date(JSONObjectUtils.getLong(json, EXPIRATION_TIME_CLAIM) * 1000L));
                continue;
            }
            if (name.equals(NOT_BEFORE_CLAIM)) {
                cs.setNotBeforeTime(new Date(JSONObjectUtils.getLong(json, NOT_BEFORE_CLAIM) * 1000L));
                continue;
            }
            if (name.equals(ISSUED_AT_CLAIM)) {
                cs.setIssueTime(new Date(JSONObjectUtils.getLong(json, ISSUED_AT_CLAIM) * 1000L));
                continue;
            }
            if (name.equals(JWT_ID_CLAIM)) {
                cs.setJWTID(JSONObjectUtils.getString(json, JWT_ID_CLAIM));
                continue;
            }
            cs.setCustomClaim(name, json.get((Object)name));
        }
        return cs;
    }

    public static JWTClaimsSet parse(String s) throws ParseException {
        return JWTClaimsSet.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public String toString() {
        return "JWTClaimsSet [iss=" + this.iss + ", sub=" + this.sub + ", aud=" + this.aud + ", exp=" + this.exp + ", nbf=" + this.nbf + ", iat=" + this.iat + ", jti=" + this.jti + ", customClaims=" + this.customClaims + "]";
    }

    static {
        HashSet<String> n = new HashSet<String>();
        n.add(ISSUER_CLAIM);
        n.add(SUBJECT_CLAIM);
        n.add(AUDIENCE_CLAIM);
        n.add(EXPIRATION_TIME_CLAIM);
        n.add(NOT_BEFORE_CLAIM);
        n.add(ISSUED_AT_CLAIM);
        n.add(JWT_ID_CLAIM);
        REGISTERED_CLAIM_NAMES = Collections.unmodifiableSet(n);
    }
}

