/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt.proc;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTClaimsVerifier
implements JWTClaimsVerifier {
    @Override
    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        Date now = new Date();
        Date exp = claimsSet.getExpirationTime();
        if (exp != null && now.after(exp)) {
            throw new BadJWTException("Expired JWT");
        }
        Date nbf = claimsSet.getNotBeforeTime();
        if (nbf != null && now.before(nbf)) {
            throw new BadJWTException("JWT before use time");
        }
    }
}

