/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

abstract class ECDSAProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    static {
        LinkedHashSet<JWSAlgorithm> algs = new LinkedHashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.ES256);
        algs.add(JWSAlgorithm.ES256K);
        algs.add(JWSAlgorithm.ES384);
        algs.add(JWSAlgorithm.ES512);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }

    protected ECDSAProvider(JWSAlgorithm alg) throws JOSEException {
        super(new HashSet<JWSAlgorithm>(Collections.singletonList(alg)));
        if (!SUPPORTED_ALGORITHMS.contains(alg)) {
            throw new JOSEException("Unsupported EC DSA algorithm: " + alg);
        }
    }

    public JWSAlgorithm supportedECDSAAlgorithm() {
        return this.supportedJWSAlgorithms().iterator().next();
    }
}

