/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.PrettyConfigBuilder;
import com.ocpsoft.pretty.faces.config.dynaview.DynaviewEngine;
import com.ocpsoft.pretty.faces.config.servlet.WebXmlParser;
import com.ocpsoft.pretty.faces.config.spi.ParentingPostProcessor;
import com.ocpsoft.pretty.faces.config.spi.ValidatingPostProcessor;
import com.ocpsoft.pretty.faces.spi.ConfigurationPostProcessor;
import com.ocpsoft.pretty.faces.spi.ConfigurationProvider;
import com.ocpsoft.pretty.faces.util.ServiceLoader;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import javax.servlet.ServletContext;

public class PrettyConfigurator {
    private static final Log log = LogFactory.getLog(PrettyConfigurator.class);
    private final ServletContext servletContext;
    private final WebXmlParser webXmlParser = new WebXmlParser();
    private final DynaviewEngine dynaview = new DynaviewEngine();
    private PrettyConfig config;

    public PrettyConfigurator(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void configure() {
        try {
            PrettyConfigBuilder builder = new PrettyConfigBuilder();
            ServiceLoader<ConfigurationProvider> configLoader = ServiceLoader.load(ConfigurationProvider.class);
            for (ConfigurationProvider p : configLoader) {
                builder.addFromConfig(p.loadConfiguration(this.servletContext));
            }
            this.config = builder.build();
            this.config.setDynaviewId(this.getFacesDynaViewId());
            ParentingPostProcessor parenting = new ParentingPostProcessor();
            this.config = parenting.processConfiguration(this.servletContext, this.config);
            ServiceLoader<ConfigurationPostProcessor> postProcessors = ServiceLoader.load(ConfigurationPostProcessor.class);
            for (ConfigurationPostProcessor p : postProcessors) {
                this.config = p.processConfiguration(this.servletContext, this.config);
            }
            ValidatingPostProcessor validating = new ValidatingPostProcessor();
            this.config = validating.processConfiguration(this.servletContext, this.config);
            log.trace("Setting config into ServletContext");
            this.servletContext.setAttribute("com.ocpsoft.pretty.CONFIG_FILES", (Object)this.config);
        }
        catch (Exception e) {
            throw new PrettyException("Failed to load configuration.", e);
        }
    }

    private String getFacesDynaViewId() {
        try {
            this.webXmlParser.parse(this.servletContext);
            return this.dynaview.buildDynaViewId(this.webXmlParser.getFacesMapping());
        }
        catch (Exception e) {
            throw new PrettyException("Could not retrieve DynaViewId.", e);
        }
    }

    public PrettyConfig getConfig() {
        return this.config;
    }
}

