/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.mapping;

import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.PathValidator;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlAction;
import com.ocpsoft.pretty.faces.el.Expressions;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.url.URLPatternParser;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlMapping {
    private String id = "";
    private String parentId = "";
    private boolean outbound = true;
    private String viewId = "";
    private List<UrlAction> actions = new ArrayList<UrlAction>();
    private String pattern = "";
    private List<QueryParameter> queryParams = new ArrayList<QueryParameter>();
    private List<PathValidator> pathValidators = new ArrayList<PathValidator>();
    private boolean onPostback = true;
    private URLPatternParser parser = null;

    public boolean isDynaView() {
        return Expressions.isEL(this.viewId);
    }

    public URLPatternParser getPatternParser() {
        if (this.parser == null && this.pattern != null) {
            this.parser = new URLPatternParser(this.pattern);
        }
        return this.parser;
    }

    public List<PathValidator> getValidatorsForPathParam(PathParameter param) {
        ArrayList<PathValidator> result = new ArrayList<PathValidator>();
        for (PathValidator pv : this.pathValidators) {
            if (pv.getIndex() != param.getPosition()) continue;
            result.add(pv);
        }
        return result;
    }

    public boolean matches(URL url) {
        return this.getPatternParser().matches(url);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public List<UrlAction> getActions() {
        return this.actions;
    }

    public void setActions(List<UrlAction> actions) {
        this.actions = actions;
    }

    public void addAction(UrlAction action) {
        this.actions.add(action);
    }

    public void addPathValidator(PathValidator v) {
        this.pathValidators.add(v);
    }

    public List<PathValidator> getPathValidators() {
        return this.pathValidators;
    }

    public void setPathValidators(List<PathValidator> pathValidators) {
        this.pathValidators = pathValidators;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.parser = null;
    }

    public boolean addQueryParam(QueryParameter param) {
        return this.queryParams.add(param);
    }

    public List<QueryParameter> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(List<QueryParameter> queryParams) {
        this.queryParams = queryParams;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UrlMapping)) {
            return false;
        }
        UrlMapping other = (UrlMapping)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "UrlMapping [ id=" + this.id + ", pattern=" + this.pattern + ", parentId=" + this.parentId + ", viewId=" + this.viewId + ", actions=" + this.actions + ", outbound=" + this.outbound + ", parser=" + this.parser + ", pathValidators=" + this.pathValidators + ", queryParams=" + this.queryParams + "]";
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public void setOutbound(boolean outbound) {
        this.outbound = outbound;
    }

    public boolean isOnPostback() {
        return this.onPostback;
    }

    public void setOnPostback(boolean onPostback) {
        this.onPostback = onPostback;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean hasParent() {
        return this.parentId != null && !"".equals(this.parentId.trim());
    }
}

