/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.RequestParameter;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryString {
    private static final Log log = LogFactory.getLog(QueryString.class);
    private final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();

    public static QueryString build(Map<String, String[]> params) {
        QueryString queryString = new QueryString();
        queryString.addParameters(params);
        return queryString;
    }

    public static <T extends RequestParameter> QueryString build(List<T> params) {
        QueryString queryString = new QueryString();
        queryString.addParameters(params);
        return queryString;
    }

    public static QueryString build(String url) {
        QueryString queryString = new QueryString();
        queryString.addParameters(url);
        return queryString;
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String getParameter(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        if (values.size() == 0) {
            return "";
        }
        return values.get(0);
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map<String, String[]> getParameterMap() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            List<String> list = entry.getValue();
            String[] values = list == null ? null : list.toArray(new String[list.size()]);
            map.put(entry.getKey(), values);
        }
        return map;
    }

    public <T extends RequestParameter> void addParameters(List<T> params) {
        for (RequestParameter rp : params) {
            String value = rp.getValue();
            String name = rp.getName();
            if (!this.parameters.containsKey(name)) {
                ArrayList<String> values = new ArrayList<String>();
                if (value != null) {
                    values.add(value);
                }
                this.parameters.put(name, values);
                continue;
            }
            this.parameters.get(name).add(value);
        }
    }

    public void addParameters(Map<String, String[]> params) {
        if (params != null) {
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                List<Object> values = null;
                if (entry.getValue() != null) {
                    values = Arrays.asList((Object[])entry.getValue());
                }
                this.parameters.put(entry.getKey(), values);
            }
        }
    }

    public void addParameters(String url) {
        if (url != null && !"".equals(url) && (url = url.trim()).length() > 1) {
            String[] pairs;
            if (url.contains("?")) {
                url = url.substring(url.indexOf(63) + 1);
            }
            for (String pair : pairs = url.split("&(amp;)?")) {
                String value;
                String name;
                int pos = pair.indexOf(61);
                if (pos == -1) {
                    name = pair;
                    value = null;
                } else {
                    try {
                        name = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
                        value = URLDecoder.decode(pair.substring(pos + 1, pair.length()), "UTF-8");
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Ignoring invalid query parameter: " + pair);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new PrettyException("UTF-8 encoding not supported. Something is seriously wrong with your environment.");
                    }
                }
                List<String> list = this.parameters.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.parameters.put(name, list);
                }
                list.add(value);
            }
        }
    }

    public String toQueryString() {
        try {
            StringBuffer result = new StringBuffer();
            if (null != this.parameters && !this.parameters.isEmpty()) {
                result.append("?");
                Iterator<Map.Entry<String, List<String>>> iterator = this.parameters.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, List<String>> entry = iterator.next();
                    String key = entry.getKey();
                    List<String> values = entry.getValue();
                    if (key != null && !"".equals(key)) {
                        key = URLEncoder.encode(key, "UTF-8");
                        result.append(key);
                        if (values != null && !values.isEmpty()) {
                            for (int i = 0; i < values.size(); ++i) {
                                String value = values.get(i);
                                if (value != null && !"".equals(value)) {
                                    value = URLEncoder.encode(value, "UTF-8");
                                    result.append("=" + value);
                                } else if (value != null && "".equals(value)) {
                                    result.append("=");
                                }
                                if (i >= values.size() - 1) continue;
                                result.append("&" + key);
                            }
                        }
                    }
                    if (!iterator.hasNext()) continue;
                    result.append("&");
                }
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new PrettyException("Error building query string.", e);
        }
    }

    public String toString() {
        return this.toQueryString();
    }

    public List<String> removeParameter(String string) {
        return this.parameters.remove(string);
    }
}

