/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;

public class Publisher {
    private String component;
    private ONS oems;
    private Object lock;
    private int eventId;
    private int id;
    private String idString;

    public Publisher(String c) throws ONSException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PublishPermission("ONSUser"));
        }
        this.oems = ONS.getONS();
        this.realStartup(c);
    }

    Publisher(ONS o, String c) {
        this.oems = o;
        this.realStartup(c);
    }

    private void realStartup(String c) {
        this.component = c;
        this.lock = new Object();
        this.eventId = 1;
        this.oems.addPublisher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Notification e) {
        int myeventid;
        Object object = this.lock;
        synchronized (object) {
            myeventid = this.eventId++;
        }
        e.generatingComponent = this.component;
        e.generatingNode = this.oems.hostname();
        e.generatingProcess = this.oems.processId();
        e.id = this.idString + new Integer(myeventid);
        e.creationTime = System.currentTimeMillis();
        this.oems.publish(e);
    }

    public void close() {
        this.oems.removePublisher(this);
    }

    public int id() {
        return this.id;
    }

    protected void id(int i) {
        this.id = i;
        this.idString = this.oems.processId() + new Integer(i).toString();
    }
}

