/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractEntryIterator<K, V, T>
implements OLazyIterator<T> {
    OMVRBTree<K, V> tree;
    OMVRBTreeEntry<K, V> next;
    OMVRBTreeEntry<K, V> lastReturned;
    int expectedModCount;
    int pageIndex;

    AbstractEntryIterator(OMVRBTreeEntry<K, V> first) {
        if (first == null) {
            return;
        }
        this.tree = first.getTree();
        this.next = first;
        this.expectedModCount = this.tree.modCount;
        this.lastReturned = null;
        this.pageIndex = -1;
    }

    @Override
    public final boolean hasNext() {
        if (this.tree != null && this.expectedModCount != this.tree.modCount) {
            --this.pageIndex;
            this.expectedModCount = this.tree.modCount;
        }
        return this.next != null && (this.pageIndex < this.next.getSize() - 1 || OMVRBTree.successor(this.next) != null);
    }

    final K nextKey() {
        return this.nextEntry().getKey(this.pageIndex);
    }

    final V nextValue() {
        return this.nextEntry().getValue(this.pageIndex);
    }

    final OMVRBTreeEntry<K, V> nextEntry() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        if (this.pageIndex < this.next.getSize() - 1) {
            ++this.pageIndex;
        } else {
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = OMVRBTree.successor(this.next);
            this.pageIndex = 0;
        }
        this.lastReturned = this.next;
        this.tree.pageIndex = this.pageIndex;
        return this.next;
    }

    final OMVRBTreeEntry<K, V> prevEntry() {
        OMVRBTreeEntry<K, V> e = this.next;
        if (e == null) {
            throw new NoSuchElementException();
        }
        if (this.pageIndex > 0) {
            --this.pageIndex;
        } else {
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = OMVRBTree.predecessor(e);
            this.pageIndex = this.next.getSize() - 1;
        }
        this.lastReturned = e;
        return e;
    }

    @Override
    public T update(T iValue) {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.tree.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        this.tree.pageIndex = this.pageIndex;
        return this.next.setValue(iValue);
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.tree.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastReturned.getLeft() != null && this.lastReturned.getRight() != null) {
            this.next = this.lastReturned;
        }
        this.tree.pageIndex = this.pageIndex--;
        this.next = this.tree.deleteEntry(this.lastReturned);
        this.expectedModCount = this.tree.modCount;
        this.lastReturned = null;
    }
}

