/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.binary.OBinaryTokenSerializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OStorageRemoteNodeSession {
    private final String serverURL;
    private Integer sessionId = -1;
    private byte[] token = null;
    private OToken tokenInstance = null;

    public OStorageRemoteNodeSession(String serverURL, Integer uniqueClientSessionId) {
        this.serverURL = serverURL;
        this.sessionId = uniqueClientSessionId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setSession(Integer sessionId, byte[] token) {
        this.sessionId = sessionId;
        this.token = token;
        if (token != null) {
            OBinaryTokenSerializer binarySerializer = new OBinaryTokenSerializer();
            try {
                this.tokenInstance = binarySerializer.deserialize((InputStream)new ByteArrayInputStream(token));
            }
            catch (IOException e) {
                OLogManager.instance().debug((Object)this, "Error deserializing binary token", (Throwable)e, new Object[0]);
            }
        }
    }

    public boolean isExpired() {
        if (this.tokenInstance != null) {
            return !this.tokenInstance.isNowValid();
        }
        return false;
    }

    public boolean isValid() {
        return this.sessionId >= 0 && !this.isExpired();
    }
}

