/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OReadRecordResponse;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OReadRecordRequest
implements OBinaryRequest<OReadRecordResponse> {
    private boolean ignoreCache;
    private ORecordId rid;
    private String fetchPlan;
    private boolean loadTumbstone;

    public OReadRecordRequest(boolean iIgnoreCache, ORecordId iRid, String iFetchPlan, boolean iLoadTumbstone) {
        this.ignoreCache = iIgnoreCache;
        this.rid = iRid;
        this.fetchPlan = iFetchPlan;
        this.loadTumbstone = iLoadTumbstone;
    }

    public OReadRecordRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeRID((ORID)this.rid);
        network.writeString(this.fetchPlan != null ? this.fetchPlan : "");
        network.writeByte((byte)(this.ignoreCache ? 1 : 0));
        network.writeByte((byte)(this.loadTumbstone ? 1 : 0));
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.rid = channel.readRID();
        this.fetchPlan = channel.readString();
        this.ignoreCache = channel.readByte() != 0;
        this.loadTumbstone = channel.readByte() != 0;
    }

    @Override
    public byte getCommand() {
        return 30;
    }

    @Override
    public String getDescription() {
        return "Load record";
    }

    public ORecordId getRid() {
        return this.rid;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public boolean isIgnoreCache() {
        return this.ignoreCache;
    }

    public boolean isLoadTumbstone() {
        return this.loadTumbstone;
    }

    @Override
    public OReadRecordResponse createResponse() {
        return new OReadRecordResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeReadRecord(this);
    }
}

