/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OSBTCreateTreeRequest
implements OBinaryRequest<OSBTCreateTreeResponse> {
    private int clusterId;

    public OSBTCreateTreeRequest(int clusterId) {
        this.clusterId = clusterId;
    }

    public OSBTCreateTreeRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeInt(this.clusterId);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.clusterId = channel.readInt();
    }

    @Override
    public byte getCommand() {
        return 110;
    }

    @Override
    public String getDescription() {
        return "Create SB-Tree bonsai instance";
    }

    public int getClusterId() {
        return this.clusterId;
    }

    @Override
    public OSBTCreateTreeResponse createResponse() {
        return new OSBTCreateTreeResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeSBTreeCreate(this);
    }
}

